/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.compact;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.base.compact.AbstractCompact;
import net.automatalib.ts.powerset.DeterministicPowersetView;
import net.automatalib.words.Alphabet;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractCompactDeterministic<I, T, SP, TP>
extends AbstractCompact<I, T, SP, TP>
implements MutableDeterministic<Integer, I, T, SP, TP>,
MutableDeterministic.StateIntAbstraction<I, T, SP, TP>,
MutableDeterministic.FullIntAbstraction<T, SP, TP>,
Serializable {
    private int initial = -1;

    public AbstractCompactDeterministic(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        super(alphabet, stateCapacity, resizeFactor);
    }

    public AbstractCompactDeterministic(Alphabet<I> alphabet, AbstractCompactDeterministic<?, ?, ?, ?> other) {
        super(alphabet, other);
        this.initial = other.initial;
    }

    public void setInitialState(@Nullable Integer state) {
        this.setInitialState(AbstractCompactDeterministic.toId(state));
    }

    public void setInitialState(int stateId) {
        this.initial = stateId;
    }

    public SP getStateProperty(Integer state) {
        return (SP)this.getStateProperty(state);
    }

    public int getIntInitialState() {
        return this.initial;
    }

    public @Nullable Integer getInitialState() {
        return AbstractCompactDeterministic.toState(this.initial);
    }

    public @Nullable T getTransition(int state, I input) {
        return this.getTransition(state, (I)this.getSymbolIndex(input));
    }

    public @Nullable T getTransition(Integer state, I input) {
        return this.getTransition((int)state, input);
    }

    public void setTransition(Integer state, I input, @Nullable T transition) {
        this.setTransition((int)state, (I)this.getSymbolIndex(input), transition);
    }

    public void setTransition(int state, I input, @Nullable T transition) {
        this.setTransition(state, (I)this.getSymbolIndex(input), transition);
    }

    public void setTransition(int state, I input, int successor, TP property) {
        this.setTransition(state, this.getSymbolIndex(input), successor, property);
    }

    public void setStateProperty(Integer state, SP property) {
        this.setStateProperty((int)state, property);
    }

    public T createTransition(Integer successor, TP properties) {
        return (T)this.createTransition(successor, properties);
    }

    public int addIntInitialState(@Nullable SP property) {
        this.setInitial(this.addIntState(property), true);
        return this.initial;
    }

    public Integer getSuccessor(T transition) {
        return this.getIntSuccessor(transition);
    }

    @Override
    public void clear() {
        this.initial = -1;
        super.clear();
    }

    public MutableDeterministic.FullIntAbstraction<T, SP, TP> fullIntAbstraction(Alphabet<I> alphabet) {
        if (Objects.equals(this.getInputAlphabet(), alphabet)) {
            return this;
        }
        return super.fullIntAbstraction(alphabet);
    }

    public MutableDeterministic.StateIntAbstraction<I, T, SP, TP> stateIntAbstraction() {
        return this;
    }

    public DeterministicPowersetView<Integer, I, T> powersetView() {
        return new DeterministicPowersetView(this);
    }

    @Override
    public Collection<I> getLocalInputs(Integer state) {
        Alphabet alphabet = this.getInputAlphabet();
        ArrayList result = new ArrayList(alphabet.size());
        for (Object i : alphabet) {
            if (this.getTransition(state, (I)i) == null) continue;
            result.add(i);
        }
        return result;
    }
}

