/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.impl;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.automatalib.words.GrowingAlphabet;
import net.automatalib.words.abstractimpl.AbstractAlphabet;

public class SimpleAlphabet<I>
extends AbstractAlphabet<I>
implements GrowingAlphabet<I> {
    @Nonnull
    private final List<I> symbols;
    @Nonnull
    private final Map<I, Integer> indexMap;

    public SimpleAlphabet() {
        this(new ArrayList());
    }

    public SimpleAlphabet(Collection<? extends I> symbols) {
        this.symbols = new ArrayList<I>(symbols);
        this.indexMap = Maps.newHashMapWithExpectedSize((int)symbols.size());
        int i = 0;
        for (I sym : this.symbols) {
            this.indexMap.put(sym, i++);
        }
    }

    @Override
    public boolean add(I a) {
        int s = this.size();
        int idx = this.addSymbol(a);
        return idx == s;
    }

    @Override
    public Iterator<I> iterator() {
        return Iterators.unmodifiableIterator(this.symbols.iterator());
    }

    @Override
    public int size() {
        return this.symbols.size();
    }

    public int addSymbol(I a) {
        Integer idx = this.indexMap.get(a);
        if (idx != null) {
            return idx;
        }
        idx = this.size();
        this.symbols.add(a);
        this.indexMap.put(a, idx);
        return idx;
    }

    @Override
    public I get(int index) {
        return this.getSymbol(index);
    }

    public I getSymbol(int index) {
        return this.symbols.get(index);
    }

    public int getSymbolIndex(I symbol) {
        return this.indexMap.get(symbol);
    }

    public int compare(I o1, I o2) {
        return this.indexMap.get(o1) - this.indexMap.get(o2);
    }

    public boolean containsSymbol(I symbol) {
        return this.indexMap.containsKey(symbol);
    }
}

