/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.automatalib.words.VPDAlphabet;
import net.automatalib.words.abstractimpl.AbstractVPDAlphabet;

public class DefaultVPDAlphabet<I>
extends AbstractVPDAlphabet<I> {
    private final int internalStart;
    private final int internalEnd;
    private final int callStart;
    private final int callEnd;
    private final int returnStart;
    private final int returnEnd;
    private final List<I> symbols;

    public DefaultVPDAlphabet(Collection<I> internalSymbols, Collection<I> callSymbols, Collection<I> returnSymbols) {
        DefaultVPDAlphabet.validateDisjointness(internalSymbols, VPDAlphabet.SymbolType.INTERNAL, callSymbols, returnSymbols);
        DefaultVPDAlphabet.validateDisjointness(callSymbols, VPDAlphabet.SymbolType.CALL, returnSymbols);
        this.internalStart = 0;
        this.callStart = this.internalEnd = internalSymbols.size();
        this.returnStart = this.callEnd = this.callStart + callSymbols.size();
        this.returnEnd = this.returnStart + returnSymbols.size();
        ArrayList<I> tmp = new ArrayList<I>(this.returnEnd);
        tmp.addAll(internalSymbols);
        tmp.addAll(callSymbols);
        tmp.addAll(returnSymbols);
        this.symbols = Collections.unmodifiableList(tmp);
    }

    public I getCallSymbol(int index) throws IllegalArgumentException {
        int idx = index + this.callStart;
        this.validateIndex(idx, this.callStart, this.callEnd, "Index not within its expected bounds");
        return this.getSymbol(idx);
    }

    public int getCallSymbolIndex(I symbol) throws IllegalArgumentException {
        int idx = this.getSymbolIndex(symbol);
        this.validateIndex(idx, this.callStart, this.callEnd, "Call alphabet does not contain the queried symbol");
        return idx - this.callStart;
    }

    public Collection<I> getCallSymbols() {
        return this.symbols.subList(this.callStart, this.callEnd);
    }

    public I getInternalSymbol(int index) throws IllegalArgumentException {
        int idx = index + this.internalStart;
        this.validateIndex(idx, this.internalStart, this.internalEnd, "Index not within its expected bounds");
        return this.getSymbol(idx);
    }

    public int getInternalSymbolIndex(I symbol) throws IllegalArgumentException {
        int idx = this.getSymbolIndex(symbol);
        this.validateIndex(idx, this.internalStart, this.internalEnd, "Internal alphabet does not contain the queried symbol");
        return idx - this.internalStart;
    }

    public Collection<I> getInternalSymbols() {
        return this.symbols.subList(this.internalStart, this.internalEnd);
    }

    public I getReturnSymbol(int index) throws IllegalArgumentException {
        int idx = index + this.returnStart;
        this.validateIndex(idx, this.returnStart, this.returnEnd, "Index not within its expected bounds");
        return this.getSymbol(idx);
    }

    public int getReturnSymbolIndex(I symbol) throws IllegalArgumentException {
        int idx = this.getSymbolIndex(symbol);
        this.validateIndex(idx, this.returnStart, this.returnEnd, "Return alphabet does not contain the queried symbol");
        return idx - this.returnStart;
    }

    public Collection<I> getReturnSymbols() {
        return this.symbols.subList(this.returnStart, this.returnEnd);
    }

    public int getNumCalls() {
        return this.callEnd - this.callStart;
    }

    public int getNumInternals() {
        return this.internalEnd - this.internalStart;
    }

    public int getNumReturns() {
        return this.returnEnd - this.returnStart;
    }

    public VPDAlphabet.SymbolType getSymbolType(I symbol) {
        int idx = this.getSymbolIndex(symbol);
        if (idx < this.internalEnd) {
            return VPDAlphabet.SymbolType.INTERNAL;
        }
        if (idx < this.callEnd) {
            return VPDAlphabet.SymbolType.CALL;
        }
        return VPDAlphabet.SymbolType.RETURN;
    }

    @Nullable
    public I getSymbol(int index) throws IllegalArgumentException {
        this.validateIndex(index, 0, this.symbols.size(), "Index not within its expected bounds");
        return this.symbols.get(index);
    }

    public int getSymbolIndex(@Nullable I symbol) throws IllegalArgumentException {
        int localIdx = this.symbols.indexOf(symbol);
        if (localIdx < 0) {
            throw new IllegalArgumentException("Alphabet does not contain the queried symbol");
        }
        return localIdx;
    }

    @Override
    public int size() {
        return this.symbols.size();
    }

    private void validateIndex(int idx, int lowerBound, int upperBound, String errorMessage) {
        if (idx < lowerBound || idx >= upperBound) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @SafeVarargs
    private static <I> void validateDisjointness(Collection<I> source, VPDAlphabet.SymbolType type, Collection<I> ... rest) {
        HashSet<I> sourceAsSet = new HashSet<I>(source);
        int initialSize = sourceAsSet.size();
        for (Collection<I> c : rest) {
            sourceAsSet.removeAll(c);
        }
        if (sourceAsSet.size() < initialSize) {
            throw new IllegalArgumentException("The set of " + type + " symbols is not disjoint with the sets of other symbols.");
        }
    }
}

