/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecking.modelchecker.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.automatalib.automata.simple.SimpleAutomaton;
import net.automatalib.commons.util.Pair;
import net.automatalib.modelchecking.ModelChecker;
import net.automatalib.modelchecking.ModelCheckerCache;

class SizeModelCheckerCache<I, A extends SimpleAutomaton<?, I>, P, R>
implements ModelCheckerCache<I, A, P, R> {
    private final Map<Pair<Collection<? extends I>, P>, Optional<R>> counterExamples = new HashMap<Pair<Collection<? extends I>, P>, Optional<R>>();
    private int size = Integer.MAX_VALUE;
    private final ModelChecker<I, A, P, R> modelChecker;

    SizeModelCheckerCache(ModelChecker<I, A, P, R> modelChecker) {
        this.modelChecker = modelChecker;
    }

    @Nullable
    public R findCounterExample(A automaton, Collection<? extends I> inputs, P property) {
        if (automaton.size() > this.size) {
            this.counterExamples.clear();
        }
        this.size = automaton.size();
        return this.counterExamples.computeIfAbsent(Pair.of(inputs, property), key -> Optional.ofNullable(this.modelChecker.findCounterExample((Object)automaton, inputs, property))).orElse(null);
    }

    public void clear() {
        this.counterExamples.clear();
    }
}

