/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecking.lasso;

import java.util.Collection;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.concepts.DetOutputAutomaton;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.modelchecking.Lasso;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;
import net.automatalib.words.impl.Alphabets;

@ParametersAreNonnullByDefault
public abstract class AbstractLasso<I, D>
implements Lasso<I, D> {
    public static final String NO_LASSO = "Automaton is not lasso shaped";
    private final Word<I> word;
    private final Word<I> loop;
    private final Word<I> prefix;
    private final D output;
    private final Alphabet<I> inputAlphabet;
    private final int unfolds;
    private final SortedSet<Integer> loopBeginIndices = new TreeSet<Integer>();
    private final DetOutputAutomaton<?, I, ?, D> automaton;

    public <S> AbstractLasso(DetOutputAutomaton<S, I, ?, D> automaton, Collection<? extends I> inputs, int unfoldTimes) {
        Object input;
        assert (unfoldTimes > 0);
        this.automaton = automaton;
        this.unfolds = unfoldTimes;
        this.inputAlphabet = Alphabets.fromCollection(inputs);
        HashMap<Object, Integer> states = new HashMap<Object, Integer>();
        WordBuilder wb = new WordBuilder();
        Object current = automaton.getInitialState();
        int i = 0;
        do {
            states.put(current, i++);
            Object c = current;
            input = this.inputAlphabet.stream().filter(in -> automaton.getSuccessor(c, in) != null).findAny().orElseThrow(() -> new IllegalArgumentException(NO_LASSO));
            wb.append(input);
        } while (!states.containsKey(current = automaton.getSuccessor(current, input)));
        int loopBegin = (Integer)states.get(current);
        this.loop = wb.toWord(loopBegin, wb.size());
        this.prefix = wb.toWord(0, loopBegin);
        for (int u = 1; u < unfoldTimes; ++u) {
            wb.append(this.loop);
        }
        this.word = wb.toWord();
        this.output = automaton.computeOutput(this.word);
        for (int l = this.prefix.length(); l <= this.word.length(); l += this.loop.length()) {
            this.loopBeginIndices.add(l);
        }
    }

    public DetOutputAutomaton<?, I, ?, D> getAutomaton() {
        return this.automaton;
    }

    public int getUnfolds() {
        return this.unfolds;
    }

    public Word<I> getWord() {
        return this.word;
    }

    public Word<I> getLoop() {
        return this.loop;
    }

    public Word<I> getPrefix() {
        return this.prefix;
    }

    public D getOutput() {
        return this.output;
    }

    public SortedSet<Integer> getLoopBeginIndices() {
        return this.loopBeginIndices;
    }

    @Nullable
    public Integer getInitialState() {
        return 0;
    }

    @Nullable
    public Integer getSuccessor(Integer state, @Nullable I input) {
        Integer result = state < this.word.length() && input.equals(this.word.getSymbol(state.intValue())) ? Integer.valueOf(state + 1) : null;
        return result;
    }

    @Nonnull
    public Collection<Integer> getStates() {
        return CollectionsUtil.intRange((int)0, (int)this.word.length());
    }

    @Nonnull
    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    @Nullable
    public Integer getTransition(Integer state, @Nullable I input) {
        return this.getSuccessor(state, input);
    }
}

