/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graphs.base.compact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.automatalib.commons.smartcollections.ResizingArrayStorage;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.graphs.MutableGraph;
import net.automatalib.graphs.base.compact.CompactEdge;
import net.automatalib.graphs.concepts.NodeIDs;

public abstract class AbstractCompactGraph<E extends CompactEdge<EP>, NP, EP>
implements MutableGraph<Integer, E, NP, EP>,
NodeIDs<Integer> {
    protected final ResizingArrayStorage<List<E>> edges;
    protected int size;

    public AbstractCompactGraph() {
        this.size = 0;
        this.edges = new ResizingArrayStorage(List.class);
    }

    public AbstractCompactGraph(int initialCapacity) {
        this.edges = new ResizingArrayStorage(List.class, initialCapacity);
    }

    public Collection<Integer> getNodes() {
        return CollectionsUtil.intRange((int)0, (int)this.size);
    }

    public NodeIDs<Integer> nodeIDs() {
        return this;
    }

    public Collection<E> getOutgoingEdges(Integer node) {
        return this.getOutgoingEdges((int)node);
    }

    public Collection<E> getOutgoingEdges(int node) {
        List<E> edgeList = this.getOutEdgeList(node);
        return Collections.unmodifiableCollection(edgeList);
    }

    protected List<E> getOutEdgeList(int node) {
        return ((List[])this.edges.array)[node];
    }

    public Integer getTarget(E edge) {
        return ((CompactEdge)edge).getTarget();
    }

    public Integer addNode(NP properties) {
        return this.addIntNode(properties);
    }

    public int addIntNode(NP properties) {
        this.edges.ensureCapacity(this.size + 1);
        ((List[])this.edges.array)[this.size] = new ArrayList();
        int n = this.size++;
        this.setNodeProperty(n, properties);
        return n;
    }

    public int addIntNode() {
        return this.addIntNode(null);
    }

    public void setNodeProperty(Integer node, NP property) {
        this.setNodeProperty((int)node, property);
    }

    public abstract void setNodeProperty(int var1, NP var2);

    public E connect(Integer source, Integer target, EP properties) {
        return this.connect((int)source, (int)target, properties);
    }

    public E connect(int source, int target, EP property) {
        E edge = this.createEdge(source, target, property);
        List<E> edges = this.getOutEdgeList(source);
        ((CompactEdge)edge).outIndex = edges.size();
        edges.add(edge);
        return edge;
    }

    public CompactEdge<EP> connect(int source, int target) {
        return this.connect(source, target, (EP)null);
    }

    protected abstract E createEdge(int var1, int var2, EP var3);

    public void setEdgeProperty(E edge, EP property) {
        ((CompactEdge)edge).setProperty(property);
    }

    public int getNodeId(Integer node) {
        return node;
    }

    public Integer getNode(int id) {
        return id;
    }

    public NP getNodeProperty(Integer node) {
        return this.getNodeProperties(node);
    }

    public abstract NP getNodeProperties(int var1);

    public EP getEdgeProperty(E edge) {
        return ((CompactEdge)edge).getProperty();
    }
}

