/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.transducers.impl.compact;

import java.io.Serializable;
import java.util.Objects;

public final class CompactMealyTransition<O>
implements Serializable {
    private int memoryIdx;
    private final int succId;
    private O output;

    CompactMealyTransition(int succId, O output) {
        this(-1, succId, output);
    }

    CompactMealyTransition(int memoryIdx, int succId, O output) {
        this.memoryIdx = memoryIdx;
        this.succId = succId;
        this.output = output;
    }

    public int getSuccId() {
        return this.succId;
    }

    public O getOutput() {
        return this.output;
    }

    void setOutput(O output) {
        this.output = output;
    }

    int getMemoryIdx() {
        return this.memoryIdx;
    }

    void setMemoryIdx(int memoryIdx) {
        this.memoryIdx = memoryIdx;
    }

    boolean isAutomatonTransition() {
        return this.memoryIdx >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompactMealyTransition)) {
            return false;
        }
        CompactMealyTransition that = (CompactMealyTransition)o;
        return this.memoryIdx == that.memoryIdx && this.succId == that.succId && Objects.equals(this.output, that.output);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Integer.hashCode(this.memoryIdx);
        result = 31 * result + Integer.hashCode(this.succId);
        result = 31 * result + Objects.hashCode(this.output);
        return result;
    }
}

