/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.transducers.impl.compact;

import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.AutomatonCreator;
import net.automatalib.automata.base.compact.AbstractCompact;
import net.automatalib.automata.base.compact.AbstractCompactDeterministic;
import net.automatalib.automata.transducers.MutableMealyMachine;
import net.automatalib.automata.transducers.StateLocalInputMealyMachine;
import net.automatalib.automata.transducers.impl.compact.CompactMealyTransition;
import net.automatalib.words.Alphabet;

@ParametersAreNonnullByDefault
public class CompactMealy<I, O>
extends AbstractCompactDeterministic<I, CompactMealyTransition<O>, Void, O>
implements MutableMealyMachine<Integer, I, CompactMealyTransition<O>, O>,
StateLocalInputMealyMachine<Integer, I, CompactMealyTransition<O>, O> {
    private int[] transitions;
    private Object[] outputs;

    public CompactMealy(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        super(alphabet, stateCapacity, resizeFactor);
        int size = stateCapacity * this.numInputs();
        this.transitions = new int[size];
        this.outputs = new Object[size];
        Arrays.fill(this.transitions, 0, size, -1);
    }

    public CompactMealy(Alphabet<I> alphabet, int stateCapacity) {
        this(alphabet, stateCapacity, 1.5f);
    }

    public CompactMealy(Alphabet<I> alphabet) {
        this(alphabet, 11, 1.5f);
    }

    @Override
    protected void updateTransitionStorage(AbstractCompact.Payload payload) {
        this.transitions = this.updateTransitionStorage(this.transitions, -1, payload);
        this.outputs = this.updateTransitionStorage(this.outputs, null, payload);
    }

    public O getTransitionOutput(CompactMealyTransition<O> transition) {
        return transition.getOutput();
    }

    public O getTransitionProperty(CompactMealyTransition<O> transition) {
        return transition.getOutput();
    }

    public void setTransitionProperty(CompactMealyTransition<O> transition, O property) {
        transition.setOutput(property);
        if (transition.isAutomatonTransition()) {
            this.outputs[transition.getMemoryIdx()] = property;
        }
    }

    public void setTransitionOutput(CompactMealyTransition<O> transition, O output) {
        this.setTransitionProperty(transition, output);
    }

    public void removeAllTransitions(Integer state) {
        int lower = state * this.numInputs();
        int upper = lower + this.numInputs();
        Arrays.fill(this.transitions, lower, upper, -1);
        Arrays.fill(this.outputs, lower, upper, null);
    }

    public int getIntSuccessor(CompactMealyTransition<O> transition) {
        return transition.getSuccId();
    }

    public CompactMealyTransition<O> createTransition(int succId, O property) {
        return new CompactMealyTransition<O>(succId, property);
    }

    @Override
    public void setStateProperty(int state, Void property) {
    }

    public Void getStateProperty(int stateId) {
        return null;
    }

    @Override
    public void setTransition(int state, int input, CompactMealyTransition<O> transition) {
        if (transition == null) {
            this.setTransition(state, input, -1, (O)null);
        } else {
            this.setTransition(state, input, transition.getSuccId(), transition.getOutput());
            transition.setMemoryIdx(this.toMemoryIndex(state, input));
        }
    }

    @Override
    public void setTransition(int state, int input, int successor, @Nullable O property) {
        int idx = this.toMemoryIndex(state, input);
        this.transitions[idx] = successor;
        this.outputs[idx] = property;
    }

    @Override
    public void clear() {
        int endIdx = this.size() * this.numInputs();
        Arrays.fill(this.transitions, 0, endIdx, -1);
        Arrays.fill(this.outputs, 0, endIdx, null);
        super.clear();
    }

    @Override
    public CompactMealyTransition<O> getTransition(int state, int input) {
        int idx = this.toMemoryIndex(state, input);
        int succ = this.transitions[idx];
        if (succ == -1) {
            return null;
        }
        Object output = this.outputs[idx];
        return new CompactMealyTransition<Object>(idx, succ, output);
    }

    public static final class Creator<I, O>
    implements AutomatonCreator<CompactMealy<I, O>, I> {
        public CompactMealy<I, O> createAutomaton(Alphabet<I> alphabet, int sizeHint) {
            return new CompactMealy(alphabet, sizeHint);
        }

        public CompactMealy<I, O> createAutomaton(Alphabet<I> alphabet) {
            return new CompactMealy(alphabet);
        }
    }
}

