/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.fsa.impl.compact;

import java.util.BitSet;
import net.automatalib.automata.AutomatonCreator;
import net.automatalib.automata.base.compact.AbstractCompactSimpleNondet;
import net.automatalib.automata.fsa.MutableNFA;
import net.automatalib.commons.util.WrapperUtil;
import net.automatalib.words.Alphabet;

public class CompactNFA<I>
extends AbstractCompactSimpleNondet<I, Boolean>
implements MutableNFA<Integer, I> {
    private final BitSet accepting;

    public CompactNFA(Alphabet<I> alphabet, int stateCapacity) {
        super(alphabet, stateCapacity, 1.5f);
        this.accepting = new BitSet();
    }

    public CompactNFA(Alphabet<I> alphabet) {
        this(alphabet, 11);
    }

    protected CompactNFA(Alphabet<I> alphabet, CompactNFA<?> other) {
        super(alphabet, (AbstractCompactSimpleNondet<?, ?>)other);
        this.accepting = (BitSet)other.accepting.clone();
    }

    public <I2> CompactNFA<I2> translate(Alphabet<I2> newAlphabet) {
        if (this.numInputs() != newAlphabet.size()) {
            throw new IllegalArgumentException("Can only translate automata with matching alphabet sizes, found: " + newAlphabet.size() + " (new) vs. " + this.numInputs() + " (old)");
        }
        return new CompactNFA<I2>(newAlphabet, this);
    }

    public boolean isAccepting(Integer state) {
        return this.isAccepting((int)state);
    }

    public boolean isAccepting(int stateId) {
        return this.accepting.get(stateId);
    }

    public void flipAcceptance() {
        this.accepting.flip(0, this.size());
    }

    public void setAccepting(Integer state, boolean accepting) {
        this.setAccepting((int)state, accepting);
    }

    public void setAccepting(int stateId, boolean accepting) {
        if (accepting) {
            this.accepting.set(stateId);
        } else {
            this.accepting.clear(stateId);
        }
    }

    public Integer addInitialState(boolean accepting) {
        return (Integer)super.addInitialState((Object)accepting);
    }

    @Override
    public Integer addState(boolean accepting) {
        return this.addState((Object)accepting);
    }

    @Override
    public void clear() {
        this.accepting.clear(0, this.size());
        super.clear();
    }

    @Override
    public void setStateProperty(int stateId, Boolean property) {
        this.setAccepting(stateId, WrapperUtil.booleanValue((Boolean)property));
    }

    public static final class Creator<I>
    implements AutomatonCreator<CompactNFA<I>, I> {
        public CompactNFA<I> createAutomaton(Alphabet<I> alphabet, int numStates) {
            return new CompactNFA<I>(alphabet, numStates);
        }

        public CompactNFA<I> createAutomaton(Alphabet<I> alphabet) {
            return new CompactNFA<I>(alphabet);
        }
    }
}

