/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.fast;

import java.io.Serializable;
import java.util.Collection;
import net.automatalib.SupportsGrowingAlphabet;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.automata.ShrinkableAutomaton;
import net.automatalib.automata.UniversalFiniteAlphabetAutomaton;
import net.automatalib.automata.base.StateIDDynamicMapping;
import net.automatalib.automata.base.fast.AbstractFastState;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.concepts.StateLocalInput;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.commons.util.nid.DynamicList;
import net.automatalib.commons.util.nid.IDChangeNotifier;
import net.automatalib.exception.GrowingAlphabetNotSupportedException;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;

public abstract class AbstractFastMutable<S extends AbstractFastState<?>, I, T, SP, TP>
implements ShrinkableAutomaton<S, I, T, SP, TP>,
UniversalFiniteAlphabetAutomaton<S, I, T, SP, TP>,
StateIDs<S>,
SupportsGrowingAlphabet<I>,
StateLocalInput<S, I>,
Serializable {
    protected final Alphabet<I> inputAlphabet;
    private final DynamicList<S> states = new DynamicList();
    private final transient IDChangeNotifier<S> tracker = new IDChangeNotifier();

    public AbstractFastMutable(Alphabet<I> inputAlphabet) {
        this.inputAlphabet = inputAlphabet;
    }

    public int getStateId(S state) {
        return state.getId();
    }

    public S getState(int id) {
        return (S)((Object)((AbstractFastState)this.states.get(id)));
    }

    public S addState(SP property) {
        S newState = this.createState(property);
        this.states.add(newState);
        return newState;
    }

    public void removeAllTransitions(S state) {
        ((AbstractFastState)((Object)state)).clearTransitionObjects();
    }

    protected abstract S createState(SP var1);

    public void removeState(S state, S replacement) {
        ShrinkableAutomaton.unlinkState((MutableAutomaton)this, state, replacement, this.inputAlphabet);
        this.states.remove(state, this.tracker);
    }

    public void clear() {
        this.states.clear();
    }

    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    public <V> MutableMapping<S, V> createDynamicStateMapping() {
        StateIDDynamicMapping mapping = new StateIDDynamicMapping(this);
        this.tracker.addListener(mapping, true);
        return mapping;
    }

    public void addAlphabetSymbol(I symbol) throws GrowingAlphabetNotSupportedException {
        if (!this.inputAlphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.inputAlphabet).addSymbol(symbol);
        }
        int newAlphabetSize = this.inputAlphabet.size();
        for (AbstractFastState s : this.getStates()) {
            s.ensureInputCapacity(newAlphabetSize);
        }
    }

    public Collection<S> getStates() {
        return this.states;
    }

    public StateIDs<S> stateIDs() {
        return this;
    }
}

