/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.compact;

import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.base.compact.AbstractCompact;
import net.automatalib.automata.base.compact.AbstractCompactDeterministic;
import net.automatalib.words.Alphabet;

@ParametersAreNonnullByDefault
public abstract class AbstractCompactSimpleDeterministic<I, SP>
extends AbstractCompactDeterministic<I, Integer, SP, Void> {
    protected int[] transitions;

    public AbstractCompactSimpleDeterministic(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        super(alphabet, stateCapacity, resizeFactor);
        this.transitions = new int[stateCapacity * this.numInputs()];
        Arrays.fill(this.transitions, 0, this.transitions.length, -1);
    }

    public AbstractCompactSimpleDeterministic(Alphabet<I> alphabet, AbstractCompactSimpleDeterministic<?, ?> other) {
        super(alphabet, (AbstractCompactDeterministic<?, ?, ?, ?>)other);
        this.transitions = (int[])other.transitions.clone();
    }

    public Integer createTransition(int successor, Void property) {
        return successor;
    }

    public Integer getState(Iterable<? extends I> input) {
        return AbstractCompactSimpleDeterministic.toState(this.getIntSuccessor(this.getIntInitialState(), input));
    }

    public Integer getSuccessor(Integer state, Iterable<? extends I> input) {
        return AbstractCompactSimpleDeterministic.toState(this.getIntSuccessor(state, input));
    }

    @Override
    public Integer getTransition(int state, int input) {
        return AbstractCompactSimpleDeterministic.toState(this.transitions[this.toMemoryIndex(state, input)]);
    }

    @Override
    protected void updateTransitionStorage(AbstractCompact.Payload payload) {
        this.transitions = this.updateTransitionStorage(this.transitions, -1, payload);
    }

    public void setTransitionProperty(Integer transition, @Nullable Void property) {
    }

    public void removeAllTransitions(Integer state) {
        int lower = state * this.numInputs();
        int upper = lower + this.numInputs();
        Arrays.fill(this.transitions, lower, upper, -1);
    }

    @Override
    public void setTransition(int state, int input, Integer transition) {
        this.setTransition(state, input, AbstractCompactSimpleDeterministic.toId(transition));
    }

    @Override
    public void setTransition(int state, int input, int successor, Void property) {
        this.setTransition(state, input, successor);
    }

    @Override
    public void setTransition(int state, int inputIdx, int succ) {
        this.transitions[this.toMemoryIndex((int)state, (int)inputIdx)] = succ;
    }

    @Nullable
    public Void getTransitionProperty(Integer transition) {
        return null;
    }

    @Override
    public void clear() {
        Arrays.fill(this.transitions, 0, this.size() * this.numInputs(), -1);
        super.clear();
    }

    public int getIntSuccessor(Integer transition) {
        return AbstractCompactSimpleDeterministic.toId(transition);
    }

    private int getIntSuccessor(int state, Iterable<? extends I> input) {
        int current = state;
        Iterator<I> inputIt = input.iterator();
        while (current >= 0 && inputIt.hasNext()) {
            current = this.transitions[this.toMemoryIndex(current, this.getSymbolIndex(inputIt.next()))];
        }
        return current;
    }
}

