/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.compact;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.SupportsGrowingAlphabet;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.automata.UniversalFiniteAlphabetAutomaton;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.concepts.StateLocalInput;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.exception.GrowingAlphabetNotSupportedException;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;

@ParametersAreNonnullByDefault
public abstract class AbstractCompact<I, T, SP, TP>
implements MutableAutomaton<Integer, I, T, SP, TP>,
StateIDs<Integer>,
UniversalFiniteAlphabetAutomaton<Integer, I, T, SP, TP>,
SupportsGrowingAlphabet<I>,
StateLocalInput<Integer, I>,
Serializable {
    protected static final float DEFAULT_RESIZE_FACTOR = 1.5f;
    protected static final int DEFAULT_INIT_CAPACITY = 11;
    protected static final int INVALID_STATE = -1;
    private final Alphabet<I> alphabet;
    private final float resizeFactor;
    private int alphabetSize;
    private int stateCapacity;
    private int numStates;

    public AbstractCompact(Alphabet<I> alphabet, AbstractCompact<?, ?, ?, ?> other) {
        this(alphabet, other.stateCapacity, other.resizeFactor);
        this.numStates = other.numStates;
    }

    public AbstractCompact(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        this.alphabet = alphabet;
        this.alphabetSize = alphabet.size();
        this.resizeFactor = resizeFactor;
        this.stateCapacity = stateCapacity;
    }

    public Collection<Integer> getStates() {
        return CollectionsUtil.intRange((int)0, (int)this.numStates);
    }

    public StateIDs<Integer> stateIDs() {
        return this;
    }

    public int size() {
        return this.numStates;
    }

    public int getStateId(Integer state) {
        return AbstractCompact.toId(state);
    }

    public Integer getState(int id) {
        return AbstractCompact.toState(id);
    }

    public void clear() {
        this.numStates = 0;
    }

    public final Integer addState(@Nullable SP property) {
        return this.addIntState(property);
    }

    public int addIntState(@Nullable SP property) {
        int newState = this.numStates++;
        this.ensureCapacity(this.numStates);
        this.setStateProperty(newState, property);
        return newState;
    }

    private void ensureCapacity(int newCapacity) {
        if (newCapacity <= this.stateCapacity) {
            return;
        }
        int newCap = Math.max((int)((float)this.stateCapacity * this.resizeFactor), newCapacity);
        Payload p = Payload.of(this.stateCapacity, newCap, this.numStates, this.stateCapacity, this.alphabetSize, TransitionUpdateOperation.NEW_STATE);
        this.updateStateStorage(p);
        this.updateTransitionStorage(p);
        this.stateCapacity = newCap;
    }

    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    public final void addAlphabetSymbol(I symbol) throws GrowingAlphabetNotSupportedException {
        int newAlphabetSize;
        if (!this.alphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.alphabet).addSymbol(symbol);
        }
        if (this.alphabetSize < (newAlphabetSize = this.alphabet.size())) {
            this.updateTransitionStorage(Payload.of(this.alphabetSize, newAlphabetSize, this.numStates, this.stateCapacity, this.alphabetSize, TransitionUpdateOperation.NEW_ALPHABET_SYMBOL));
            this.alphabetSize = newAlphabetSize;
        }
    }

    public Collection<I> getLocalInputs(Integer state) {
        ArrayList result = new ArrayList(this.alphabet.size());
        for (Object i : this.alphabet) {
            if (this.getTransitions(state, i).isEmpty()) continue;
            result.add(i);
        }
        return result;
    }

    public abstract void setStateProperty(int var1, @Nullable SP var2);

    protected void updateStateStorage(Payload payload) {
    }

    protected final Object[] updateStateStorage(Object[] oldStorage, @Nullable Object defaultValue, Payload payload) {
        Object[] result = Arrays.copyOf(oldStorage, payload.newSizeHint);
        Arrays.fill(result, oldStorage.length, result.length, defaultValue);
        return result;
    }

    protected void updateTransitionStorage(Payload payload) {
    }

    protected final int[] updateTransitionStorage(int[] oldStorage, int defaultValue, Payload payload) {
        return payload.type.updateStorage(oldStorage, payload, int[]::new, (arr, idx) -> {
            arr[idx] = defaultValue;
        });
    }

    protected final Object[] updateTransitionStorage(Object[] oldStorage, @Nullable Object defaultValue, Payload payload) {
        return payload.type.updateStorage(oldStorage, payload, Object[]::new, (arr, idx) -> {
            arr[idx] = defaultValue;
        });
    }

    protected final <T> T[] updateTransitionStorage(T[] oldStorage, IntFunction<T[]> arrayConstructor, @Nullable T defaultValue, Payload payload) {
        return payload.type.updateStorage(oldStorage, payload, arrayConstructor, (arr, idx) -> {
            arr[idx] = defaultValue;
        });
    }

    protected static Integer toState(int id) {
        return id != -1 ? Integer.valueOf(id) : null;
    }

    protected static int toId(@Nullable Integer id) {
        return id != null ? id : -1;
    }

    protected final int toMemoryIndex(int stateId, int inputId) {
        return stateId * this.alphabetSize + inputId;
    }

    protected final int getSymbolIndex(@Nullable I input) {
        return this.alphabet.getSymbolIndex(input);
    }

    public final int numInputs() {
        return this.alphabetSize;
    }

    protected static final class Payload {
        private final int oldSizeHint;
        private final int newSizeHint;
        private final int alphabetSize;
        private final int numStates;
        private final int stateCapacity;
        private final TransitionUpdateOperation type;

        private Payload(int oldSizeHint, int newSizeHint, int numStates, int stateCapacity, int alphabetSize, TransitionUpdateOperation type) {
            this.oldSizeHint = oldSizeHint;
            this.newSizeHint = newSizeHint;
            this.alphabetSize = alphabetSize;
            this.numStates = numStates;
            this.stateCapacity = stateCapacity;
            this.type = type;
        }

        private static Payload of(int oldSizeHint, int newSizeHint, int numStates, int stateCapacity, int alphabetSize, TransitionUpdateOperation type) {
            return new Payload(oldSizeHint, newSizeHint, numStates, stateCapacity, alphabetSize, type);
        }
    }

    private static interface ArrayInitializer<T> {
        public void setDefaultValue(T var1, int var2);
    }

    private static enum TransitionUpdateOperation {
        NEW_STATE{

            @Override
            <T> T updateStorage(T oldStorage, Payload p, IntFunction<T> arrayConstructor, ArrayInitializer<T> initializer) {
                T newStorage = arrayConstructor.apply(p.newSizeHint * p.alphabetSize);
                System.arraycopy(oldStorage, 0, newStorage, 0, p.oldSizeHint * p.alphabetSize);
                for (int i = p.oldSizeHint * p.alphabetSize; i < p.newSizeHint * p.alphabetSize; ++i) {
                    initializer.setDefaultValue(newStorage, i);
                }
                return newStorage;
            }
        }
        ,
        NEW_ALPHABET_SYMBOL{

            @Override
            <T> T updateStorage(T oldStorage, Payload p, IntFunction<T> arrayConstructor, ArrayInitializer<T> initializer) {
                int i;
                T newStorage = arrayConstructor.apply(p.newSizeHint * p.stateCapacity);
                for (i = 0; i < p.numStates; ++i) {
                    System.arraycopy(oldStorage, i * p.oldSizeHint, newStorage, i * p.newSizeHint, p.oldSizeHint);
                    for (int j = i * p.newSizeHint + p.oldSizeHint; j < (i + 1) * p.newSizeHint; ++j) {
                        initializer.setDefaultValue(newStorage, j);
                    }
                }
                for (i = p.newSizeHint * p.numStates; i < p.newSizeHint * p.stateCapacity; ++i) {
                    initializer.setDefaultValue(newStorage, i);
                }
                return newStorage;
            }
        };


        abstract <T> T updateStorage(T var1, Payload var2, IntFunction<T> var3, ArrayInitializer<T> var4);
    }
}

