/* Copyright (C) 2013-2019 TU Dortmund
 * This file is part of AutomataLib, http://www.automatalib.net/.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.automatalib.automata.transducers.impl;

import net.automatalib.automata.base.fast.AbstractFastState;

/**
 * A state in a {@link FastMoore} automaton.
 *
 * @param <O>
 *         output symbol class.
 *
 * @author Malte Isberner
 */
public final class FastMooreState<O> extends AbstractFastState<FastMooreState<O>> {

    private O output;

    /**
     * Constructor.
     *
     * @param numInputs
     *         number of input symbols.
     * @param output
     *         output symbol.
     */
    public FastMooreState(int numInputs, O output) {
        super(numInputs);
        this.output = output;
    }

    /**
     * Retrieves the output symbol generated by this state.
     *
     * @return the output symbol.
     */
    public O getOutput() {
        return output;
    }

    /**
     * Sets the output symbol generated by this state.
     *
     * @param output
     *         the output symbol.
     */
    public void setOutput(O output) {
        this.output = output;
    }
}
