/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.words.abstractimpl.AbstractAlphabet;

@ParametersAreNonnullByDefault
public class ListAlphabet<I>
extends AbstractAlphabet<I> {
    @Nonnull
    private final List<? extends I> list;

    public ListAlphabet(List<? extends I> list) {
        this.list = list;
    }

    public I getSymbol(int index) throws IllegalArgumentException {
        return this.list.get(index);
    }

    public int getSymbolIndex(I symbol) throws IllegalArgumentException {
        int idx = this.list.indexOf(symbol);
        if (idx == -1) {
            throw new IllegalArgumentException("Symbol " + symbol + " is not contained in the alphabet");
        }
        return idx;
    }

    public boolean containsSymbol(I symbol) {
        return this.list.indexOf(symbol) != -1;
    }

    @Override
    public I get(int index) {
        return this.list.get(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }
}

