/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.automatalib.words.VPDAlphabet;
import net.automatalib.words.abstractimpl.AbstractVPDAlphabet;
import net.automatalib.words.impl.VPDSym;

public class GrowingVPDAlphabet<I>
extends AbstractVPDAlphabet<VPDSym<I>> {
    private final List<VPDSym<I>> allSyms = new ArrayList<VPDSym<I>>();
    private final List<VPDSym<I>> callSyms = new ArrayList<VPDSym<I>>();
    private final List<VPDSym<I>> returnSyms = new ArrayList<VPDSym<I>>();
    private final List<VPDSym<I>> internalSyms = new ArrayList<VPDSym<I>>();

    public VPDSym<I> getSymbol(int index) throws IllegalArgumentException {
        return this.allSyms.get(index);
    }

    public int getSymbolIndex(VPDSym<I> symbol) throws IllegalArgumentException {
        if (!this.hasValidIndex(symbol, this.allSyms)) {
            throw new IllegalArgumentException();
        }
        return symbol.getGlobalIndex();
    }

    public VPDSym<I> getCallSymbol(int index) throws IllegalArgumentException {
        return this.callSyms.get(index);
    }

    public int getCallSymbolIndex(VPDSym<I> symbol) throws IllegalArgumentException {
        if (symbol.getType() != VPDAlphabet.SymbolType.CALL || !this.hasValidIndex(symbol, this.callSyms)) {
            throw new IllegalArgumentException();
        }
        return symbol.getLocalIndex();
    }

    public Collection<VPDSym<I>> getCallSymbols() {
        return this.callSyms;
    }

    public VPDSym<I> getInternalSymbol(int index) throws IllegalArgumentException {
        return this.internalSyms.get(index);
    }

    public int getInternalSymbolIndex(VPDSym<I> symbol) throws IllegalArgumentException {
        if (symbol.getType() != VPDAlphabet.SymbolType.INTERNAL || !this.hasValidIndex(symbol, this.internalSyms)) {
            throw new IllegalArgumentException();
        }
        return symbol.getLocalIndex();
    }

    public Collection<VPDSym<I>> getInternalSymbols() {
        return this.internalSyms;
    }

    public VPDSym<I> getReturnSymbol(int index) throws IllegalArgumentException {
        return this.returnSyms.get(index);
    }

    public int getReturnSymbolIndex(VPDSym<I> symbol) throws IllegalArgumentException {
        if (symbol.getType() != VPDAlphabet.SymbolType.RETURN || !this.hasValidIndex(symbol, this.returnSyms)) {
            throw new IllegalArgumentException();
        }
        return symbol.getLocalIndex();
    }

    public Collection<VPDSym<I>> getReturnSymbols() {
        return this.returnSyms;
    }

    public int getNumCalls() {
        return this.callSyms.size();
    }

    public int getNumInternals() {
        return this.internalSyms.size();
    }

    public int getNumReturns() {
        return this.returnSyms.size();
    }

    public VPDAlphabet.SymbolType getSymbolType(VPDSym<I> symbol) {
        return symbol.getType();
    }

    @Override
    public int size() {
        return this.allSyms.size();
    }

    public VPDSym<I> addNewSymbol(I userObject, VPDAlphabet.SymbolType type) {
        List<VPDSym<I>> localList;
        switch (type) {
            case CALL: {
                localList = this.callSyms;
                break;
            }
            case RETURN: {
                localList = this.returnSyms;
                break;
            }
            default: {
                localList = this.internalSyms;
            }
        }
        VPDSym<I> vpdSym = new VPDSym<I>(userObject, type, localList.size(), this.allSyms.size());
        this.allSyms.add(vpdSym);
        localList.add(vpdSym);
        return vpdSym;
    }

    private boolean hasValidIndex(VPDSym<I> symbol, List<VPDSym<I>> localSymbols) {
        int localIdx = symbol.getLocalIndex();
        int globalIdx = symbol.getGlobalIndex();
        return localIdx >= 0 && localIdx < localSymbols.size() && globalIdx >= 0 && globalIdx < this.allSyms.size();
    }
}

