/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.impl;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.automatalib.commons.util.nid.DynamicList;
import net.automatalib.commons.util.nid.MutableNumericID;
import net.automatalib.words.GrowingAlphabet;

public class FastAlphabet<I extends MutableNumericID>
extends DynamicList<I>
implements GrowingAlphabet<I> {
    public FastAlphabet() {
    }

    @SafeVarargs
    public FastAlphabet(I ... symbols) {
        this(Arrays.asList(symbols));
    }

    public FastAlphabet(List<? extends I> symbols) {
        for (MutableNumericID sym : symbols) {
            this.addSymbol((I)sym);
        }
    }

    public int addSymbol(@Nonnull I a) {
        this.add((MutableNumericID)a);
        return a.getId();
    }

    @Nonnull
    public I getSymbol(int index) {
        return (I)this.get(index);
    }

    public int getSymbolIndex(@Nonnull I symbol) {
        int id = symbol.getId();
        if (id < 0 || id >= this.size() || this.get(id) != symbol) {
            throw new IllegalArgumentException("Invalid symbol: " + symbol + " does not belong to this alphabet");
        }
        return id;
    }

    public int compare(@Nonnull I o1, @Nonnull I o2) {
        return o1.getId() - o2.getId();
    }

    public boolean containsSymbol(I symbol) {
        int index = symbol.getId();
        return index >= 0 && index < this.size() && this.get(index) == symbol;
    }
}

