/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.impl;

import java.util.Objects;
import net.automatalib.words.abstractimpl.AbstractAlphabet;

public class ArrayAlphabet<I>
extends AbstractAlphabet<I> {
    protected final I[] symbols;

    @SafeVarargs
    public ArrayAlphabet(I ... symbols) {
        this.symbols = symbols;
    }

    public I getSymbol(int index) throws IllegalArgumentException {
        if (index < 0 || index >= this.symbols.length) {
            throw new IllegalArgumentException("Index not within its expected bounds");
        }
        return this.symbols[index];
    }

    public int getSymbolIndex(I symbol) throws IllegalArgumentException {
        int idx = this.getSymbolIndexInternal(symbol);
        if (idx >= 0) {
            return idx;
        }
        throw new IllegalArgumentException("Alphabet does not contain the queried symbol");
    }

    private int getSymbolIndexInternal(I symbol) {
        for (int i = 0; i < this.symbols.length; ++i) {
            if (!Objects.equals(this.symbols[i], symbol)) continue;
            return i;
        }
        return -1;
    }

    public void writeToArray(int offset, Object[] array, int tgtOfs, int num) {
        System.arraycopy(this.symbols, offset, array, tgtOfs, num);
    }

    public boolean containsSymbol(I symbol) {
        return this.getSymbolIndexInternal(symbol) != -1;
    }

    @Override
    public int size() {
        return this.symbols.length;
    }
}

