/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.words.Alphabet;
import net.automatalib.words.GrowingAlphabet;
import net.automatalib.words.impl.ArrayAlphabet;
import net.automatalib.words.impl.EnumAlphabet;
import net.automatalib.words.impl.ListAlphabet;
import net.automatalib.words.impl.SimpleAlphabet;

public final class Alphabets {
    private Alphabets() {
    }

    @SafeVarargs
    public static <T> Alphabet<T> fromArray(T ... symbols) {
        return new ArrayAlphabet<T>(symbols);
    }

    public static <E extends Enum<E>> Alphabet<E> fromEnum(Class<E> enumClazz) {
        return Alphabets.fromEnum(enumClazz, false);
    }

    public static <E extends Enum<E>> Alphabet<E> fromEnum(Class<E> enumClazz, boolean withNull) {
        return new EnumAlphabet<E>(enumClazz, withNull);
    }

    public static Alphabet<Integer> integers(int startInclusive, int endInclusive) {
        List lst = CollectionsUtil.intRange((int)startInclusive, (int)(endInclusive + 1));
        return Alphabets.fromList(lst);
    }

    public static <T> Alphabet<T> fromList(List<? extends T> list) {
        return new ListAlphabet<T>(list);
    }

    public static Alphabet<Character> characters(char startInclusive, char endInclusive) {
        List lst = CollectionsUtil.charRange((char)startInclusive, (char)((char)(endInclusive + '\u0001')));
        return Alphabets.fromList(lst);
    }

    public static Alphabet<String> closedCharStringRange(char startInclusive, char endInclusive) {
        List lst = CollectionsUtil.charStringRange((char)startInclusive, (char)((char)(endInclusive + '\u0001')));
        return Alphabets.fromList(lst);
    }

    public static <T> Alphabet<T> singleton(T symbol) {
        return Alphabets.fromList(Collections.singletonList(symbol));
    }

    public static <I> Alphabet<I> fromCollection(Collection<? extends I> coll) {
        if (coll instanceof Alphabet) {
            return (Alphabet)coll;
        }
        return new SimpleAlphabet<I>(coll);
    }

    public static <I> GrowingAlphabet<I> withNewSymbol(Alphabet<I> alphabet, I symbol) {
        if (alphabet instanceof GrowingAlphabet) {
            GrowingAlphabet growingAlphabet = (GrowingAlphabet)alphabet;
            growingAlphabet.addSymbol(symbol);
            return growingAlphabet;
        }
        ArrayList<I> alphabetAsList = new ArrayList<I>(alphabet.size() + 1);
        alphabetAsList.addAll((Collection<I>)alphabet);
        alphabetAsList.add(symbol);
        return new SimpleAlphabet(alphabetAsList);
    }
}

