/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.AutomataLibSettings;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.concepts.GraphViewable;
import net.automatalib.visualization.VPManager;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.visualization.VisualizationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Visualization {
    private static final Logger LOGGER = LoggerFactory.getLogger(Visualization.class);
    private static final Visualization INSTANCE = new Visualization();
    private final VisualizationProvider provider;

    private Visualization() {
        AutomataLibSettings settings = AutomataLibSettings.getInstance();
        String providerId = settings.getProperty("visualization.provider");
        VisualizationProvider vp = null;
        VPManager manager = new VPManager();
        manager.load();
        if (providerId != null) {
            vp = manager.getProviderByName(providerId);
        }
        if (vp == null) {
            vp = manager.getBestProvider();
        }
        if (vp == null) {
            LOGGER.error("Error setting visualization provider, defaulting to dummy provider...");
        }
        this.provider = vp;
    }

    @SafeVarargs
    public static <N, E> void visualize(Graph<N, E> graph, VisualizationHelper<N, ? super E> ... helpers) {
        Visualization.visualize(graph, true, helpers);
    }

    @SafeVarargs
    public static <N, E> void visualize(Graph<N, E> graph, boolean modal, VisualizationHelper<N, ? super E> ... helpers) {
        Visualization.visualize(graph, modal, Collections.emptyMap(), helpers);
    }

    @SafeVarargs
    public static <N, E> void visualize(Graph<N, E> graph, boolean modal, Map<String, String> options, VisualizationHelper<N, ? super E> ... helpers) {
        INSTANCE.visualizeInternal(graph, modal, options, helpers);
    }

    public static void visualize(GraphViewable gv) {
        Visualization.visualize(gv, true);
    }

    public static void visualize(GraphViewable gv, boolean modal) {
        Visualization.visualize(gv, modal, Collections.emptyMap());
    }

    public static void visualize(GraphViewable gv, boolean modal, Map<String, String> options) {
        Visualization.visualize(gv.graphView(), modal, options, new VisualizationHelper[0]);
    }

    @SafeVarargs
    public static <S, I, T> void visualize(Automaton<S, I, T> graph, Collection<? extends I> inputs, VisualizationHelper<S, ? super TransitionEdge<I, T>> ... helpers) {
        Visualization.visualize(graph, inputs, true, helpers);
    }

    @SafeVarargs
    public static <S, I, T> void visualize(Automaton<S, I, T> graph, Collection<? extends I> inputs, boolean modal, VisualizationHelper<S, ? super TransitionEdge<I, T>> ... helpers) {
        Visualization.visualize(graph, inputs, modal, Collections.emptyMap(), helpers);
    }

    @SafeVarargs
    public static <S, I, T> void visualize(Automaton<S, I, T> graph, Collection<? extends I> inputs, boolean modal, Map<String, String> options, VisualizationHelper<S, ? super TransitionEdge<I, T>> ... helpers) {
        INSTANCE.visualizeInternal(graph.transitionGraphView(inputs), modal, options, helpers);
    }

    @SafeVarargs
    private final <N, E> void visualizeInternal(Graph<N, E> graph, boolean modal, Map<String, String> options, VisualizationHelper<N, ? super E> ... helpers) {
        ArrayList allHelpers = new ArrayList(helpers.length + 1);
        allHelpers.add(graph.getVisualizationHelper());
        allHelpers.addAll(Arrays.asList(helpers));
        this.provider.visualize(graph, allHelpers, modal, options);
    }
}

