/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graphs.base.compact;

import net.automatalib.commons.util.array.ResizingObjectArray;
import net.automatalib.graphs.base.compact.AbstractCompactGraph;
import net.automatalib.graphs.base.compact.CompactEdge;

public class CompactGraph<NP, EP>
extends AbstractCompactGraph<CompactEdge<EP>, NP, EP> {
    private final ResizingObjectArray nodeProperties;

    public CompactGraph() {
        this.nodeProperties = new ResizingObjectArray();
    }

    public CompactGraph(int initialCapacity) {
        super(initialCapacity);
        this.nodeProperties = new ResizingObjectArray(initialCapacity);
    }

    @Override
    public void setNodeProperty(int node, NP property) {
        if (node >= this.nodeProperties.array.length) {
            this.nodeProperties.ensureCapacity(this.size);
        }
        this.nodeProperties.array[node] = property;
    }

    @Override
    protected CompactEdge<EP> createEdge(int source, int target, EP property) {
        return new CompactEdge<EP>(target, property);
    }

    @Override
    public NP getNodeProperties(int node) {
        if (node < this.nodeProperties.array.length) {
            return (NP)this.nodeProperties.array[node];
        }
        return null;
    }
}

