/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.vpda;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.automatalib.commons.util.array.RichArray;
import net.automatalib.words.VPDAlphabet;

public class Location {
    private final RichArray<Location> intSuccessors;
    private final RichArray<List<Location>> returnSuccessors;
    final int index;
    private boolean accepting;

    public Location(VPDAlphabet<?> alphabet, int index, boolean accepting) {
        this.index = index;
        this.accepting = accepting;
        this.intSuccessors = new RichArray(alphabet.getNumInternals());
        this.returnSuccessors = new RichArray(alphabet.getNumReturns(), ArrayList::new);
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isAccepting() {
        return this.accepting;
    }

    public void setAccepting(boolean accepting) {
        this.accepting = accepting;
    }

    public Location getReturnSuccessor(int retSymId, int stackSym) {
        List succList = (List)this.returnSuccessors.get(retSymId);
        if (succList != null && stackSym < succList.size()) {
            return (Location)succList.get(stackSym);
        }
        return null;
    }

    public void setReturnSuccessor(int retSymId, int stackSym, Location succ) {
        int numSuccs;
        ArrayList<Location> succList = (ArrayList<Location>)this.returnSuccessors.get(retSymId);
        if (succList == null) {
            succList = new ArrayList<Location>(stackSym + 1);
            this.returnSuccessors.set(retSymId, succList);
        }
        if ((numSuccs = succList.size()) <= stackSym) {
            succList.addAll(Collections.nCopies(stackSym + 1 - numSuccs, null));
        }
        succList.set(stackSym, succ);
    }

    public Location getInternalSuccessor(int intSymId) {
        return (Location)this.intSuccessors.get(intSymId);
    }

    public void setInternalSuccessor(int intSymId, Location succ) {
        this.intSuccessors.set(intSymId, (Object)succ);
    }
}

