/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.vpda;

import java.util.ArrayList;
import java.util.List;
import net.automatalib.automata.vpda.AbstractOneSEVPA;
import net.automatalib.automata.vpda.Location;
import net.automatalib.words.VPDAlphabet;

public class DefaultOneSEVPA<I>
extends AbstractOneSEVPA<Location, I> {
    private final List<Location> locations;
    private Location initLoc;

    public DefaultOneSEVPA(VPDAlphabet<I> alphabet) {
        super(alphabet);
        this.locations = new ArrayList<Location>();
    }

    public DefaultOneSEVPA(VPDAlphabet<I> alphabet, int capacity) {
        super(alphabet);
        this.locations = new ArrayList<Location>(capacity);
    }

    public Location addInitialLocation(boolean accepting) {
        Location loc = this.addLocation(accepting);
        this.setInitialLocation(loc);
        return loc;
    }

    public Location addLocation(boolean accepting) {
        Location loc = new Location(this.alphabet, this.locations.size(), accepting);
        this.locations.add(loc);
        return loc;
    }

    @Override
    public int size() {
        return this.locations.size();
    }

    public void setInternalSuccessor(Location loc, I intSym, Location succ) {
        loc.setInternalSuccessor(this.alphabet.getInternalSymbolIndex(intSym), succ);
    }

    public void setReturnSuccessor(Location loc, I retSym, int stackSym, Location succ) {
        loc.setReturnSuccessor(this.alphabet.getReturnSymbolIndex(retSym), stackSym, succ);
    }

    public Location getInternalSuccessor(Location loc, I intSym) {
        return loc.getInternalSuccessor(this.alphabet.getInternalSymbolIndex(intSym));
    }

    public Location getLocation(int id) {
        return this.locations.get(id);
    }

    public int getLocationId(Location loc) {
        return loc.getIndex();
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public Location getReturnSuccessor(Location loc, I retSym, int stackSym) {
        return loc.getReturnSuccessor(this.alphabet.getReturnSymbolIndex(retSym), stackSym);
    }

    public boolean isAcceptingLocation(Location loc) {
        return loc.isAccepting();
    }

    public Location getInitialLocation() {
        return this.initLoc;
    }

    public void setInitialLocation(Location loc) {
        this.initLoc = loc;
    }
}

