/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.vpda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.automatalib.automata.vpda.OneSEVPA;
import net.automatalib.automata.vpda.StackContents;
import net.automatalib.automata.vpda.State;
import net.automatalib.graphs.Graph;
import net.automatalib.visualization.DefaultVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.words.VPDAlphabet;

public abstract class AbstractOneSEVPA<L, I>
implements OneSEVPA<L, I>,
Graph<L, SevpaViewEdge<L, I>> {
    protected final VPDAlphabet<I> alphabet;

    public AbstractOneSEVPA(VPDAlphabet<I> alphabet) {
        this.alphabet = alphabet;
    }

    public VPDAlphabet<I> getAlphabet() {
        return this.alphabet;
    }

    public State<L> getTransition(State<L> state, I input) {
        if (state.isSink()) {
            return State.getSink();
        }
        VPDAlphabet.SymbolType type = this.alphabet.getSymbolType(input);
        switch (type) {
            case CALL: {
                int newStackElem = this.encodeStackSym(state.getLocation(), input);
                return new State(this.getInitialLocation(), StackContents.push((int)newStackElem, (StackContents)state.getStackContents()));
            }
            case RETURN: {
                if (state.getStackContents() == null) {
                    return State.getSink();
                }
                int stackElem = state.getStackContents().peek();
                Object succ = this.getReturnSuccessor(state.getLocation(), input, stackElem);
                if (succ == null) {
                    return State.getSink();
                }
                return new State(succ, state.getStackContents().pop());
            }
            case INTERNAL: {
                Object succ = this.getInternalSuccessor(state.getLocation(), input);
                if (succ == null) {
                    return State.getSink();
                }
                return new State(succ, state.getStackContents());
            }
        }
        throw new IllegalStateException("Unkown symbol type " + type);
    }

    public int encodeStackSym(L srcLoc, I callSym) {
        return this.encodeStackSym(srcLoc, this.alphabet.getCallSymbolIndex(callSym));
    }

    public int encodeStackSym(L srcLoc, int callSymIdx) {
        return this.alphabet.getNumCalls() * this.getLocationId(srcLoc) + callSymIdx;
    }

    public int getNumStackSymbols() {
        return this.size() * this.alphabet.getNumCalls();
    }

    public abstract int size();

    @Nonnull
    public Collection<L> getNodes() {
        return Collections.unmodifiableCollection(this.getLocations());
    }

    @Nonnull
    public Collection<SevpaViewEdge<L, I>> getOutgoingEdges(L location) {
        ArrayList<SevpaViewEdge<L, I>> result = new ArrayList<SevpaViewEdge<L, I>>(this.alphabet.size());
        for (Object i : this.alphabet.getInternalAlphabet()) {
            result.add(new SevpaViewEdge(location, i, -1));
        }
        for (Object i : this.alphabet.getReturnAlphabet()) {
            for (Object stackLocation : this.getLocations()) {
                for (Object stackSymbol : this.alphabet.getCallAlphabet()) {
                    result.add(new SevpaViewEdge(location, i, this.encodeStackSym(stackLocation, stackSymbol)));
                }
            }
        }
        return result;
    }

    @Nonnull
    public L getTarget(SevpaViewEdge<L, I> edge) {
        Object from = ((SevpaViewEdge)edge).from;
        Object by = ((SevpaViewEdge)edge).by;
        int stack = ((SevpaViewEdge)edge).stack;
        switch (this.alphabet.getSymbolType(by)) {
            case INTERNAL: {
                return (L)this.getInternalSuccessor(from, by);
            }
            case RETURN: {
                return (L)this.getReturnSuccessor(from, by, stack);
            }
        }
        throw new IllegalArgumentException();
    }

    public VisualizationHelper<L, SevpaViewEdge<L, I>> getVisualizationHelper() {
        return new DefaultVisualizationHelper<L, SevpaViewEdge<L, I>>(){

            protected Collection<L> initialNodes() {
                return Collections.singleton(AbstractOneSEVPA.this.getInitialLocation());
            }

            public boolean getNodeProperties(L node, Map<String, String> properties) {
                super.getNodeProperties(node, properties);
                properties.put("shape", AbstractOneSEVPA.this.isAcceptingLocation(node) ? "doublecircle" : "circle");
                properties.put("label", Integer.toString(AbstractOneSEVPA.this.getLocationId(node)));
                return true;
            }

            public boolean getEdgeProperties(L src, SevpaViewEdge<L, I> edge, L tgt, Map<String, String> properties) {
                Object by = edge.by;
                int stack = edge.stack;
                if (AbstractOneSEVPA.this.alphabet.isInternalSymbol(by)) {
                    properties.put("label", by.toString());
                } else if (AbstractOneSEVPA.this.alphabet.isReturnSymbol(by)) {
                    properties.put("label", by.toString() + "/(" + AbstractOneSEVPA.this.getStackLoc(stack) + ',' + AbstractOneSEVPA.this.getCallSym(stack) + ')');
                } else {
                    throw new IllegalArgumentException();
                }
                return true;
            }
        };
    }

    public L getStackLoc(int stackSym) {
        return (L)this.getLocation(stackSym / this.alphabet.getNumCalls());
    }

    public I getCallSym(int stackSym) {
        return (I)this.alphabet.getCallSymbol(stackSym % this.alphabet.getNumCalls());
    }

    static class SevpaViewEdge<S, I> {
        private final S from;
        private final I by;
        private final int stack;

        SevpaViewEdge(S from, I by, int stack) {
            this.from = from;
            this.by = by;
            this.stack = stack;
        }
    }
}

