/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.transout.impl.map;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.automatalib.graphs.MutableGraph;
import net.automatalib.graphs.ShrinkableGraph;

public class SimpleMapGraph<N>
implements MutableGraph<N, N, N, Void>,
ShrinkableGraph<N, N> {
    @Nonnull
    private final Map<N, Collection<N>> structureMap;
    @Nonnull
    private final Supplier<? extends Collection<N>> adjCollSupplier;

    public SimpleMapGraph() {
        this(new HashMap(), HashSet::new);
    }

    public SimpleMapGraph(Map<N, Collection<N>> structureMap, Supplier<? extends Collection<N>> adjCollSupplier) {
        this.structureMap = structureMap;
        this.adjCollSupplier = adjCollSupplier;
    }

    public SimpleMapGraph(Supplier<? extends Collection<N>> adjCollSupplier) {
        this(new HashMap(), adjCollSupplier);
    }

    public SimpleMapGraph(Map<N, Collection<N>> structureMap) {
        this(structureMap, HashSet::new);
    }

    public Iterator<N> adjacentTargetsIterator(N node) {
        return this.outgoingEdgesIterator(node);
    }

    public Collection<N> getAdjacentTargets(N node) {
        return this.getOutgoingEdges(node);
    }

    public Stream<N> adjacentTargetsStream(N node) {
        return this.outgoingEdgesStream(node);
    }

    public Collection<N> getOutgoingEdges(N node) {
        return Collections.unmodifiableCollection(this.structureMap.getOrDefault(node, Collections.emptySet()));
    }

    public N getTarget(N edge) {
        return edge;
    }

    public Set<N> getNodes() {
        return Collections.unmodifiableSet(this.structureMap.keySet());
    }

    public Iterator<N> iterator() {
        return Iterators.unmodifiableIterator(this.structureMap.keySet().iterator());
    }

    public N getNodeProperty(N node) {
        return node;
    }

    public Void getEdgeProperty(N edge) {
        return null;
    }

    public N addNode(N property) {
        this.structureMap.putIfAbsent(property, this.adjCollSupplier.get());
        return property;
    }

    public N connect(N source, N target, Void property) {
        this.structureMap.get(source).add(target);
        return target;
    }

    @Deprecated
    public void setNodeProperty(N node, N property) {
        if (!Objects.equals(node, property)) {
            throw new IllegalArgumentException();
        }
    }

    public void setEdgeProperty(N edge, Void property) {
    }

    public void removeNode(N node) {
        this.structureMap.remove(node);
        this.structureMap.values().forEach(a -> a.remove(node));
    }

    public void removeNode(N node, N replacement) {
        this.structureMap.remove(node);
        this.structureMap.values().forEach(a -> {
            if (a.remove(node)) {
                a.add(replacement);
            }
        });
    }

    public void removeEdge(N node, N edge) {
        this.structureMap.get(node).remove(edge);
    }
}

