/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.fast;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.automata.GrowableAlphabetAutomaton;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.automata.ShrinkableAutomaton;
import net.automatalib.automata.UniversalFiniteAlphabetAutomaton;
import net.automatalib.automata.base.StateIDDynamicMapping;
import net.automatalib.automata.base.fast.AbstractFastNondetState;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.helpers.StateIDStaticMapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.commons.util.nid.DynamicList;
import net.automatalib.commons.util.nid.IDChangeNotifier;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;

public abstract class AbstractFastMutableNondet<S extends AbstractFastNondetState<T>, I, T, SP, TP>
implements ShrinkableAutomaton<S, I, T, SP, TP>,
UniversalFiniteAlphabetAutomaton<S, I, T, SP, TP>,
StateIDs<S>,
GrowableAlphabetAutomaton<I> {
    private final DynamicList<S> states = new DynamicList();
    private final IDChangeNotifier<S> tracker = new IDChangeNotifier();
    private final Set<S> initialStates = new HashSet<S>();
    protected Alphabet<I> inputAlphabet;

    public AbstractFastMutableNondet(Alphabet<I> inputAlphabet) {
        this.inputAlphabet = inputAlphabet;
    }

    public int getStateId(S state) {
        return state.getId();
    }

    public S getState(int id) {
        return (S)((Object)((AbstractFastNondetState)this.states.get(id)));
    }

    public Set<S> getInitialStates() {
        return this.initialStates;
    }

    public <V> MutableMapping<S, V> createDynamicStateMapping() {
        StateIDDynamicMapping mapping = new StateIDDynamicMapping(this);
        this.tracker.addListener(mapping, true);
        return mapping;
    }

    public Collection<T> getTransitions(S state, I input) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        return ((AbstractFastNondetState)((Object)state)).getTransitions(inputIdx);
    }

    public void clear() {
        this.states.clear();
        this.initialStates.clear();
    }

    public S addState(SP property) {
        S newState = this.createState(property);
        this.states.add(newState);
        return newState;
    }

    public void setInitial(S state, boolean initial) {
        if (initial) {
            this.initialStates.add(state);
        } else {
            this.initialStates.remove(state);
        }
    }

    public void setTransitions(S state, I input, Collection<? extends T> transitions) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        ((AbstractFastNondetState)((Object)state)).setTransitions(inputIdx, transitions);
    }

    public void removeAllTransitions(S state) {
        ((AbstractFastNondetState)((Object)state)).clearTransitions();
    }

    protected abstract S createState(SP var1);

    public void removeState(S state, S replacement) {
        ShrinkableAutomaton.unlinkState((MutableAutomaton)this, state, replacement, this.inputAlphabet);
        this.states.remove(state);
        if (this.initialStates.remove(state)) {
            this.initialStates.add(state);
        }
    }

    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    public void addAlphabetSymbol(I symbol) {
        if (this.inputAlphabet.containsSymbol(symbol)) {
            return;
        }
        this.inputAlphabet = Alphabets.withNewSymbol(this.inputAlphabet, symbol);
        int newAlphabetSize = this.inputAlphabet.size();
        for (AbstractFastNondetState s : this.getStates()) {
            s.ensureInputCapacity(newAlphabetSize);
        }
    }

    public Collection<S> getStates() {
        return this.states;
    }

    public <V> MutableMapping<S, V> createStaticStateMapping() {
        return new StateIDStaticMapping((StateIDs)this, this.size());
    }

    public StateIDs<S> stateIDs() {
        return this;
    }
}

