/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.fast;

import java.io.Serializable;
import java.util.Collection;
import net.automatalib.automata.GrowableAlphabetAutomaton;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.automata.ShrinkableAutomaton;
import net.automatalib.automata.ShrinkableDeterministic;
import net.automatalib.automata.UniversalFiniteAlphabetAutomaton;
import net.automatalib.automata.base.StateIDDynamicMapping;
import net.automatalib.automata.base.fast.AbstractFastDetState;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.helpers.StateIDStaticMapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.commons.util.nid.DynamicList;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;

public abstract class AbstractFastMutableDet<S extends AbstractFastDetState<S, T>, I, T, SP, TP>
implements ShrinkableDeterministic<S, I, T, SP, TP>,
UniversalFiniteAlphabetAutomaton<S, I, T, SP, TP>,
StateIDs<S>,
GrowableAlphabetAutomaton<I>,
Serializable {
    protected Alphabet<I> inputAlphabet;
    private final DynamicList<S> states = new DynamicList();
    private S initialState;

    public AbstractFastMutableDet(Alphabet<I> inputAlphabet) {
        this.inputAlphabet = inputAlphabet;
    }

    public int getStateId(S state) {
        return state.getId();
    }

    public S getState(int id) {
        return (S)((Object)((AbstractFastDetState)this.states.get(id)));
    }

    public void setTransition(S state, I input, T transition) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        ((AbstractFastDetState)((Object)state)).setTransition(inputIdx, transition);
    }

    public S getInitialState() {
        return this.initialState;
    }

    public void setInitialState(S state) {
        this.initialState = state;
    }

    public T getTransition(S state, I input) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        return ((AbstractFastDetState)((Object)state)).getTransition(inputIdx);
    }

    public void clear() {
        this.states.clear();
        this.initialState = null;
    }

    public S addState(SP property) {
        S newState = this.createState(property);
        this.states.add(newState);
        return newState;
    }

    public void removeAllTransitions(S state) {
        ((AbstractFastDetState)((Object)state)).clearTransitions();
    }

    protected abstract S createState(SP var1);

    public void removeState(S state, S replacement) {
        ShrinkableAutomaton.unlinkState((MutableAutomaton)this, state, replacement, this.inputAlphabet);
        this.states.remove(state);
    }

    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    public <V> MutableMapping<S, V> createDynamicStateMapping() {
        return new StateIDDynamicMapping(this);
    }

    public void addAlphabetSymbol(I symbol) {
        if (this.inputAlphabet.containsSymbol(symbol)) {
            return;
        }
        this.inputAlphabet = Alphabets.withNewSymbol(this.inputAlphabet, symbol);
        int newAlphabetSize = this.inputAlphabet.size();
        for (AbstractFastDetState s : this.getStates()) {
            s.ensureInputCapacity(newAlphabetSize);
        }
    }

    public Collection<S> getStates() {
        return this.states;
    }

    public <V> MutableMapping<S, V> createStaticStateMapping() {
        return new StateIDStaticMapping((StateIDs)this, this.size());
    }

    public StateIDs<S> stateIDs() {
        return this;
    }
}

