/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.compact;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.automata.GrowableAlphabetAutomaton;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.automata.UniversalFiniteAlphabetAutomaton;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;
import net.automatalib.words.impl.SimpleAlphabet;

public abstract class AbstractCompactSimpleNondet<I, SP>
implements MutableAutomaton<Integer, I, Integer, SP, Void>,
UniversalFiniteAlphabetAutomaton<Integer, I, Integer, SP, Void>,
StateIDs<Integer>,
GrowableAlphabetAutomaton<I> {
    public static final float DEFAULT_RESIZE_FACTOR = 1.5f;
    public static final int DEFAULT_INIT_CAPACITY = 11;
    protected Alphabet<I> alphabet;
    protected final Set<Integer> initial;
    private final float resizeFactor;
    protected int alphabetSize;
    protected Set<Integer>[] transitions;
    protected int stateCapacity;
    protected int numStates;

    public AbstractCompactSimpleNondet(Alphabet<I> alphabet) {
        this(alphabet, 11, 1.5f);
    }

    public AbstractCompactSimpleNondet(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        this.alphabet = new SimpleAlphabet<I>(alphabet);
        this.alphabetSize = alphabet.size();
        this.transitions = new Set[stateCapacity * this.alphabetSize];
        this.resizeFactor = resizeFactor;
        this.stateCapacity = stateCapacity;
        this.initial = new HashSet<Integer>();
    }

    public AbstractCompactSimpleNondet(Alphabet<I> alphabet, int stateCapacity) {
        this(alphabet, stateCapacity, 1.5f);
    }

    public AbstractCompactSimpleNondet(Alphabet<I> alphabet, float resizeFactor) {
        this(alphabet, 11, resizeFactor);
    }

    protected AbstractCompactSimpleNondet(Alphabet<I> alphabet, AbstractCompactSimpleNondet<?, ?> other) {
        this.alphabet = new SimpleAlphabet<I>(alphabet);
        this.alphabetSize = alphabet.size();
        this.transitions = (Set[])other.transitions.clone();
        for (int i = 0; i < this.transitions.length; ++i) {
            Set<Integer> tgts = this.transitions[i];
            if (tgts == null) continue;
            this.transitions[i] = new HashSet<Integer>(tgts);
        }
        this.numStates = other.numStates;
        this.resizeFactor = other.resizeFactor;
        this.stateCapacity = other.stateCapacity;
        this.initial = new HashSet<Integer>();
    }

    protected static Integer wrapState(int id) {
        if (id < 0) {
            return null;
        }
        return id;
    }

    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    public Collection<Integer> getStates() {
        return CollectionsUtil.intRange((int)0, (int)this.numStates);
    }

    public StateIDs<Integer> stateIDs() {
        return this;
    }

    public int size() {
        return this.numStates;
    }

    public int getStateId(Integer state) {
        return state;
    }

    public Integer getState(int id) {
        return id;
    }

    public Set<Integer> getIntInitialStates() {
        return this.initial;
    }

    public Set<Integer> getIntTransitions(int state, I input) {
        int transId = state * this.alphabetSize + this.alphabet.getSymbolIndex(input);
        return this.successors(transId);
    }

    protected Set<Integer> successors(int transId) {
        Set<Integer> successors = this.transitions[transId];
        if (successors == null) {
            return Collections.emptySet();
        }
        return successors;
    }

    public SP getStateProperty(Integer state) {
        return this.getStateProperty((int)state);
    }

    public abstract SP getStateProperty(int var1);

    public Void getTransitionProperty(Integer transition) {
        return null;
    }

    public int addIntState() {
        return this.addIntState(null);
    }

    public int addIntState(SP property) {
        int stateId = this.numStates++;
        this.ensureCapacity(this.numStates);
        this.initState(stateId, property);
        return stateId;
    }

    public void ensureCapacity(int newCapacity) {
        if (newCapacity <= this.stateCapacity) {
            return;
        }
        int newCap = (int)((float)this.stateCapacity * this.resizeFactor);
        if (newCap < newCapacity) {
            newCap = newCapacity;
        }
        Set[] newTrans = new Set[newCap * this.alphabetSize];
        System.arraycopy(this.transitions, 0, newTrans, 0, this.stateCapacity * this.alphabetSize);
        this.transitions = newTrans;
        this.ensureCapacity(this.stateCapacity, newCap);
        this.stateCapacity = newCap;
    }

    protected void ensureCapacity(int oldCap, int newCap) {
    }

    protected abstract void initState(int var1, SP var2);

    public int addIntInitialState() {
        return this.addIntInitialState(null);
    }

    public int addIntInitialState(SP property) {
        int state = this.addIntState(property);
        this.setInitial(state, true);
        return state;
    }

    public void setInitial(Integer state, boolean initial) {
        this.setInitial((int)state, initial);
    }

    public void setInitial(int state, boolean initial) {
        if (initial) {
            this.initial.add(state);
        } else {
            this.initial.remove(state);
        }
    }

    public void clear() {
        Arrays.fill(this.transitions, 0, this.numStates * this.alphabetSize, null);
        this.numStates = 0;
        this.initial.clear();
    }

    public Integer addState(SP property) {
        return this.addIntState(property);
    }

    public void setStateProperty(Integer state, SP property) {
        this.setStateProperty((int)state, property);
    }

    public abstract void setStateProperty(int var1, SP var2);

    public void setTransitionProperty(Integer transition, Void property) {
    }

    public void removeTransition(Integer state, I input, Integer transition) {
        this.removeTransition((int)state, input, (int)transition);
    }

    public void removeTransition(int stateId, I input, int successorId) {
        this.removeTransition(stateId, this.alphabet.getSymbolIndex(input), successorId);
    }

    public void removeTransition(int stateId, int inputIdx, int successorId) {
        int transIdx = stateId * this.alphabetSize + inputIdx;
        Set<Integer> successors = this.transitions[transIdx];
        if (successors != null) {
            successors.remove(successorId);
        }
    }

    public void removeAllTransitions(Integer state, I input) {
        this.removeAllTransitions((int)state, input);
    }

    public void removeAllTransitions(int stateId, I input) {
        this.removeAllTransitions(stateId, this.alphabet.getSymbolIndex(input));
    }

    public void removeAllTransitions(int stateId, int inputIdx) {
        int transIdx = stateId * this.alphabetSize + inputIdx;
        this.transitions[transIdx] = null;
    }

    public void removeAllTransitions(Integer state) {
        this.removeAllTransitions((int)state);
    }

    public void removeAllTransitions(int state) {
        int base = state * this.alphabetSize;
        Arrays.fill(this.transitions, base, base + this.alphabetSize, null);
    }

    public Integer createTransition(Integer successor, Void properties) {
        return successor;
    }

    public void addTransition(Integer state, I input, Integer transition) {
        this.addTransition((int)state, input, (int)transition);
    }

    public void addTransition(int stateId, I input, int succId) {
        this.addTransition(stateId, this.alphabet.getSymbolIndex(input), succId);
    }

    public void addTransition(int stateId, int inputIdx, int succId) {
        int transIdx = stateId * this.alphabetSize + inputIdx;
        Set<Integer> successors = this.transitions[transIdx];
        if (successors == null) {
            this.transitions[transIdx] = successors = new HashSet<Integer>();
        }
        successors.add(succId);
    }

    public Integer copyTransition(Integer trans, Integer succ) {
        return succ;
    }

    public void setTransitions(Integer state, I input, Collection<? extends Integer> transitions) {
        ArrayList<? extends Integer> successors = new ArrayList<Integer>(transitions.size());
        successors.addAll(transitions);
        this.setTransitions((int)state, input, (Collection<? extends Integer>)successors);
    }

    public void setTransitions(int state, I input, Collection<? extends Integer> successors) {
        this.setTransitions(state, this.alphabet.getSymbolIndex(input), successors);
    }

    public void setTransitions(int state, int inputIdx, Collection<? extends Integer> successors) {
        int transIdx = state * this.alphabetSize + inputIdx;
        Set<Integer> succs = this.transitions[transIdx];
        if (succs == null) {
            this.transitions[transIdx] = succs = new HashSet<Integer>();
        } else {
            succs.clear();
        }
        succs.addAll(successors);
    }

    public Integer getSuccessor(Integer transition) {
        return transition;
    }

    public Collection<Integer> getTransitions(Integer state, I input) {
        return this.getTransitions((int)state, input);
    }

    public Set<Integer> getTransitions(int state, I input) {
        return this.getTransitions(state, this.alphabet.getSymbolIndex(input));
    }

    public Set<Integer> getTransitions(int state, int inputIdx) {
        return this.successors(state * this.alphabetSize + inputIdx);
    }

    public Set<Integer> getInitialStates() {
        return this.initial;
    }

    public void addAlphabetSymbol(I symbol) {
        if (this.alphabet.containsSymbol(symbol)) {
            return;
        }
        int oldAlphabetSize = this.alphabetSize;
        int newAlphabetSize = oldAlphabetSize + 1;
        int newArraySize = this.transitions.length + this.stateCapacity;
        Set[] newTransitions = new Set[newArraySize];
        for (int i = 0; i < this.numStates; ++i) {
            System.arraycopy(this.transitions, i * oldAlphabetSize, newTransitions, i * newAlphabetSize, oldAlphabetSize);
        }
        this.transitions = newTransitions;
        this.alphabet = Alphabets.withNewSymbol(this.alphabet, symbol);
        this.alphabetSize = newAlphabetSize;
    }
}

