/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.compact;

import java.io.Serializable;
import java.util.Collection;
import net.automatalib.automata.GrowableAlphabetAutomaton;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.UniversalFiniteAlphabetAutomaton;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;

public abstract class AbstractCompactDeterministic<I, T, SP, TP>
implements MutableDeterministic<Integer, I, T, SP, TP>,
StateIDs<Integer>,
UniversalFiniteAlphabetAutomaton<Integer, I, T, SP, TP>,
MutableDeterministic.StateIntAbstraction<I, T, SP, TP>,
MutableDeterministic.FullIntAbstraction<T, SP, TP>,
GrowableAlphabetAutomaton<I>,
Serializable {
    public static final float DEFAULT_RESIZE_FACTOR = 1.5f;
    public static final int DEFAULT_INIT_CAPACITY = 11;
    protected Alphabet<I> alphabet;
    protected final float resizeFactor;
    protected int alphabetSize;
    protected Object[] transitions;
    protected int stateCapacity;
    protected int numStates;
    protected int initial = -1;

    public AbstractCompactDeterministic(Alphabet<I> alphabet) {
        this(alphabet, 11, 1.5f);
    }

    public AbstractCompactDeterministic(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        this.alphabet = alphabet;
        this.alphabetSize = alphabet.size();
        this.transitions = new Object[stateCapacity * this.alphabetSize];
        this.resizeFactor = resizeFactor;
        this.stateCapacity = stateCapacity;
    }

    public AbstractCompactDeterministic(Alphabet<I> alphabet, int stateCapacity) {
        this(alphabet, stateCapacity, 1.5f);
    }

    public AbstractCompactDeterministic(Alphabet<I> alphabet, float resizeFactor) {
        this(alphabet, 11, resizeFactor);
    }

    public void setTransition(int stateId, int inputIdx, int succId) {
        this.setTransition(stateId, (I)inputIdx, succId, null);
    }

    public void setTransition(int state, int inputIdx, T trans) {
        this.transitions[state * this.alphabetSize + inputIdx] = trans;
    }

    public void setTransition(int stateId, int inputIdx, int succId, TP property) {
        this.setTransition(stateId, (I)inputIdx, this.createTransition(succId, property));
    }

    public void setTransition(Integer state, I input, T transition) {
        this.setTransition(AbstractCompactDeterministic.getId(state), (I)this.alphabet.getSymbolIndex(input), transition);
    }

    public void setTransition(int state, I input, T trans) {
        this.setTransition(state, (I)this.alphabet.getSymbolIndex(input), trans);
    }

    public void setTransition(int stateId, I input, int succId, TP property) {
        this.setTransition(stateId, input, this.createTransition(succId, property));
    }

    protected static int getId(Integer id) {
        return id != null ? id : -1;
    }

    public void setInitialState(Integer state) {
        this.setInitialState(AbstractCompactDeterministic.getId(state));
    }

    public void setInitialState(int stateId) {
        this.initial = stateId;
    }

    public MutableDeterministic.FullIntAbstraction<T, SP, TP> fullIntAbstraction(Alphabet<I> alphabet) {
        if (alphabet == this.alphabet) {
            return this;
        }
        return super.fullIntAbstraction(alphabet);
    }

    public MutableDeterministic.FullIntAbstraction<T, SP, TP> fullIntAbstraction() {
        return this;
    }

    public MutableDeterministic.StateIntAbstraction<I, T, SP, TP> stateIntAbstraction() {
        return this;
    }

    public final Integer getSuccessor(T transition) {
        return AbstractCompactDeterministic.makeId(this.getIntSuccessor(transition));
    }

    protected static Integer makeId(int id) {
        return id != -1 ? Integer.valueOf(id) : null;
    }

    public Collection<Integer> getStates() {
        return CollectionsUtil.intRange((int)0, (int)this.numStates);
    }

    public StateIDs<Integer> stateIDs() {
        return this;
    }

    public int size() {
        return this.numStates;
    }

    public int getStateId(Integer state) {
        return state;
    }

    public Integer getState(int id) {
        return id;
    }

    public int getIntInitialState() {
        return this.initial;
    }

    public Integer getInitialState() {
        return AbstractCompactDeterministic.makeId(this.initial);
    }

    public int addIntState() {
        return this.addIntState(null);
    }

    public int addIntState(SP property) {
        int newState = this.createState();
        this.setStateProperty(newState, property);
        return newState;
    }

    public int addIntInitialState() {
        return this.addIntInitialState(null);
    }

    public int addIntInitialState(SP property) {
        int newState = this.addIntState(property);
        this.setInitialState(newState);
        return newState;
    }

    protected final int createState() {
        int newState = this.numStates++;
        this.ensureCapacity(this.numStates);
        return newState;
    }

    public void setStateProperty(Integer state, SP property) {
        this.setStateProperty((int)state, property);
    }

    public abstract void setStateProperty(int var1, SP var2);

    public final void ensureCapacity(int newCapacity) {
        if (newCapacity <= this.stateCapacity) {
            return;
        }
        int newCap = (int)((float)this.stateCapacity * this.resizeFactor);
        if (newCap < newCapacity) {
            newCap = newCapacity;
        }
        Object[] newTrans = new Object[newCap * this.alphabetSize];
        System.arraycopy(this.transitions, 0, newTrans, 0, this.stateCapacity * this.alphabetSize);
        this.transitions = newTrans;
        this.stateCapacity = newCap;
        this.ensureCapacity();
    }

    protected void ensureCapacity() {
    }

    public T getTransition(int stateId, I input) {
        return this.getTransition(stateId, this.alphabet.getSymbolIndex(input));
    }

    public T getTransition(int stateId, int inputIdx) {
        return (T)this.transitions[stateId * this.alphabetSize + inputIdx];
    }

    public T getTransition(Integer state, I input) {
        return this.getTransition(AbstractCompactDeterministic.getId(state), this.alphabet.getSymbolIndex(input));
    }

    public SP getStateProperty(Integer state) {
        return this.getStateProperty(AbstractCompactDeterministic.getId(state));
    }

    public abstract SP getStateProperty(int var1);

    public void clear() {
        int endIdx = this.numStates * this.alphabetSize;
        this.numStates = 0;
        for (int i = 0; i < endIdx; ++i) {
            this.transitions[i] = null;
        }
        this.initial = -1;
    }

    public Integer addState(SP property) {
        return this.addIntState(property);
    }

    public void removeAllTransitions(Integer state) {
        int base = state * this.alphabetSize;
        for (int i = 0; i < this.alphabetSize; ++i) {
            this.transitions[base++] = null;
        }
    }

    public T createTransition(Integer succ, TP property) {
        return this.createTransition(AbstractCompactDeterministic.getId(succ), property);
    }

    public abstract T createTransition(int var1, TP var2);

    public T copyTransition(T trans, Integer succ) {
        return this.copyTransition(trans, AbstractCompactDeterministic.getId(succ));
    }

    public abstract T copyTransition(T var1, int var2);

    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    public int numInputs() {
        return this.alphabetSize;
    }

    public void addAlphabetSymbol(I symbol) {
        if (this.alphabet.containsSymbol(symbol)) {
            return;
        }
        int oldAlphabetSize = this.alphabetSize;
        int newAlphabetSize = oldAlphabetSize + 1;
        int newArraySize = this.transitions.length + this.stateCapacity;
        Object[] newTransitions = new Object[newArraySize];
        for (int i = 0; i < this.numStates; ++i) {
            System.arraycopy(this.transitions, i * oldAlphabetSize, newTransitions, i * newAlphabetSize, oldAlphabetSize);
        }
        this.transitions = newTransitions;
        this.alphabet = Alphabets.withNewSymbol(this.alphabet, symbol);
        this.alphabetSize = newAlphabetSize;
    }
}

