/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.powerset;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.commons.util.nid.NumericID;
import net.automatalib.ts.DeterministicTransitionSystem;
import net.automatalib.ts.PowersetViewTS;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.ts.powerset.FastPowersetState;

public class FastPowersetDTS<S extends NumericID, I, T>
implements DeterministicTransitionSystem<FastPowersetState<S>, I, Set<? extends T>>,
PowersetViewTS<FastPowersetState<S>, I, Set<? extends T>, S, T> {
    private final TransitionSystem<S, I, T> ts;

    public FastPowersetDTS(TransitionSystem<S, I, T> ts) {
        this.ts = ts;
    }

    public FastPowersetState<S> getInitialState() {
        FastPowersetState<NumericID> result = new FastPowersetState<NumericID>();
        for (NumericID init : this.ts.getInitialStates()) {
            result.add(init, init.getId());
        }
        return result;
    }

    public Set<? extends T> getTransition(FastPowersetState<S> state, I input) {
        HashSet result = new HashSet();
        for (NumericID s : state) {
            Collection transitions = this.ts.getTransitions((Object)s, input);
            result.addAll(transitions);
        }
        return result;
    }

    public FastPowersetState<S> getSuccessor(Set<? extends T> transition) {
        FastPowersetState<NumericID> succ = new FastPowersetState<NumericID>();
        for (T t : transition) {
            NumericID succS = (NumericID)this.ts.getSuccessor(t);
            succ.add(succS, succS.getId());
        }
        return succ;
    }

    public FastPowersetState<S> getSuccessor(FastPowersetState<S> state, I input) {
        FastPowersetState<NumericID> succ = new FastPowersetState<NumericID>();
        for (NumericID s : state) {
            Set succs = this.ts.getSuccessors((Object)s, input);
            for (NumericID succS : succs) {
                succ.add(succS, succS.getId());
            }
        }
        return succ;
    }

    public Collection<? extends S> getOriginalStates(FastPowersetState<S> state) {
        return state;
    }

    public Collection<? extends T> getOriginalTransitions(Set<? extends T> transition) {
        return transition;
    }
}

