/* Copyright (C) 2013 TU Dortmund
 * This file is part of AutomataLib, http://www.automatalib.net/.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.automatalib.automata.fsa.impl;

import net.automatalib.automata.base.fast.FastMutableDet;
import net.automatalib.automata.fsa.MutableDFA;
import net.automatalib.words.Alphabet;

public final class FastDFA<I> extends FastMutableDet<FastDFAState, I, FastDFAState, Boolean, Void>
		implements MutableDFA<FastDFAState,I> {

	public FastDFA(Alphabet<I> alphabet) {
		super(alphabet);
	}
	
	protected FastDFAState createState(boolean accepting) {
		FastDFAState s = new FastDFAState(inputAlphabet.size(),
				accepting);
		return s;
	}

	@Override
	protected FastDFAState createState(Boolean accepting) {
		boolean acc = (accepting != null) ? accepting.booleanValue() : false;
		return createState(acc);
	}

	@Override
	public boolean isAccepting(FastDFAState state) {
		return state.isAccepting();
	}


	@Override
	public FastDFAState addState(boolean accepting) {
		FastDFAState s = addState(Boolean.valueOf(accepting));
		return s;
	}

	@Override
	public void setAccepting(FastDFAState state, boolean accepting) {
		state.setAccepting(accepting);
	}

}
