/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.impl;

import java.util.Collections;
import java.util.List;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.ArrayAlphabet;
import net.automatalib.words.impl.EnumAlphabet;
import net.automatalib.words.impl.ListAlphabet;

public abstract class Alphabets {
    public static <T> Alphabet<T> fromList(List<? extends T> list) {
        return new ListAlphabet<T>(list);
    }

    @SafeVarargs
    public static <T> Alphabet<T> fromArray(T ... symbols) {
        return new ArrayAlphabet<T>(symbols);
    }

    public static <E extends Enum<E>> Alphabet<E> fromEnum(Class<E> enumClazz, boolean withNull) {
        return new EnumAlphabet<E>(enumClazz, withNull);
    }

    public static <E extends Enum<E>> Alphabet<E> fromEnum(Class<E> enumClazz) {
        return Alphabets.fromEnum(enumClazz, false);
    }

    public static Alphabet<Integer> integers(int startInclusive, int endInclusive) {
        List lst = CollectionsUtil.intRange((int)startInclusive, (int)(endInclusive + 1));
        return Alphabets.fromList(lst);
    }

    public static Alphabet<Character> characters(char startInclusive, char endInclusive) {
        List lst = CollectionsUtil.charRange((char)startInclusive, (char)((char)(endInclusive + '\u0001')));
        return Alphabets.fromList(lst);
    }

    public static Alphabet<String> closedCharStringRange(char startInclusive, char endInclusive) {
        List lst = CollectionsUtil.charStringRange((char)startInclusive, (char)((char)(endInclusive + '\u0001')));
        return Alphabets.fromList(lst);
    }

    public static <T> Alphabet<T> singleton(T symbol) {
        return Alphabets.fromList(Collections.singletonList(symbol));
    }

    private Alphabets() {
    }
}

