/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.fsa.impl.compact;

import java.util.BitSet;
import net.automatalib.automata.AutomatonCreator;
import net.automatalib.automata.base.compact.AbstractCompactSimpleDet;
import net.automatalib.automata.fsa.MutableDFA;
import net.automatalib.words.Alphabet;

public class CompactDFA<I>
extends AbstractCompactSimpleDet<I, Boolean>
implements MutableDFA<Integer, I> {
    public static final float DEFAULT_RESIZE_FACTOR = 1.5f;
    public static final int DEFAULT_INIT_CAPACITY = 11;
    private final BitSet acceptance;

    public CompactDFA(Alphabet<I> alphabet) {
        super(alphabet);
        this.acceptance = new BitSet();
    }

    public CompactDFA(Alphabet<I> alphabet, int stateCapacity) {
        super(alphabet, stateCapacity);
        this.acceptance = new BitSet();
    }

    public CompactDFA(Alphabet<I> alphabet, float resizeFactor) {
        super(alphabet, resizeFactor);
        this.acceptance = new BitSet();
    }

    public CompactDFA(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        super(alphabet, stateCapacity, resizeFactor);
        this.acceptance = new BitSet();
    }

    protected CompactDFA(Alphabet<I> alphabet, CompactDFA<?> other) {
        super(alphabet, other);
        this.acceptance = (BitSet)other.acceptance.clone();
    }

    public <I2> CompactDFA<I2> translate(Alphabet<I2> newAlphabet) {
        if (newAlphabet.size() != this.alphabetSize) {
            throw new IllegalArgumentException("Alphabet sizes must match, but they do not (old/new): " + this.alphabetSize + " vs. " + newAlphabet.size());
        }
        return new CompactDFA<I2>(newAlphabet, this);
    }

    @Override
    public void ensureCapacity(int oldCap, int newCap) {
        this.acceptance.set(newCap);
    }

    public void flipAcceptance() {
        this.acceptance.flip(0, this.size());
    }

    @Override
    public void clear() {
        this.acceptance.clear();
        super.clear();
    }

    public void setAccepting(int state, boolean accepting) {
        this.acceptance.set(state, accepting);
    }

    public void setAccepting(Integer state, boolean accepting) {
        this.setAccepting((int)state, accepting);
    }

    @Override
    public Integer addState(boolean accepting) {
        return this.addState((Object)accepting);
    }

    public boolean isAccepting(int stateId) {
        return this.acceptance.get(stateId);
    }

    public boolean isAccepting(Integer state) {
        return this.isAccepting((int)state);
    }

    @Override
    public Boolean getStateProperty(int stateId) {
        return this.isAccepting(stateId);
    }

    @Override
    public void initState(int stateId, Boolean property) {
        boolean bval = property == null ? false : property;
        this.setAccepting(stateId, bval);
    }

    @Override
    public void setStateProperty(int stateId, Boolean property) {
        boolean bval = property == null ? false : property;
        this.setAccepting(stateId, bval);
    }

    public Integer addInitialState(boolean accepting) {
        return (Integer)super.addInitialState((Object)accepting);
    }

    public static final class Creator<I>
    implements AutomatonCreator<CompactDFA<I>, I> {
        public CompactDFA<I> createAutomaton(Alphabet<I> alphabet) {
            return new CompactDFA<I>(alphabet);
        }

        public CompactDFA<I> createAutomaton(Alphabet<I> alphabet, int numStates) {
            return new CompactDFA<I>(alphabet, numStates);
        }
    }
}

