/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.automatalib.words.GrowingAlphabet;
import net.automatalib.words.abstractimpl.AbstractAlphabet;

public class SimpleAlphabet<I>
extends AbstractAlphabet<I>
implements GrowingAlphabet<I> {
    @Nonnull
    private final List<I> symbols = new ArrayList<I>();
    @Nonnull
    private final Map<I, Integer> indexMap = new HashMap<I, Integer>();

    @Override
    public boolean add(I a) {
        int s = this.size();
        int idx = this.addSymbol(a);
        return idx == s;
    }

    public int addSymbol(I a) {
        Integer idx = this.indexMap.get(a);
        if (idx != null) {
            return idx;
        }
        idx = this.size();
        this.symbols.add(a);
        this.indexMap.put(a, idx);
        return idx;
    }

    @Override
    public Iterator<I> iterator() {
        return Collections.unmodifiableList(this.symbols).iterator();
    }

    @Override
    public int size() {
        return this.symbols.size();
    }

    public I getSymbol(int index) {
        return this.symbols.get(index);
    }

    public int getSymbolIndex(I symbol) {
        return this.indexMap.get(symbol);
    }

    @Override
    public I get(int index) {
        return this.getSymbol(index);
    }

    @Override
    public int compare(I o1, I o2) {
        return this.indexMap.get(o1) - this.indexMap.get(o2);
    }
}

