/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.powerset;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.ts.PowersetViewTS;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.ts.abstractimpl.AbstractDTS;

public class DirectPowersetDTS<S, I, T>
extends AbstractDTS<Set<? extends S>, I, Set<? extends T>>
implements PowersetViewTS<Set<? extends S>, I, Set<? extends T>, S, T> {
    private final TransitionSystem<S, I, T> ts;

    public DirectPowersetDTS(TransitionSystem<S, I, T> ts) {
        this.ts = ts;
    }

    public Set<? extends S> getInitialState() {
        return this.ts.getInitialStates();
    }

    public Set<? extends T> getTransition(Set<? extends S> state, I input) {
        HashSet result = new HashSet();
        for (S s : state) {
            Collection transitions = this.ts.getTransitions(s, input);
            result.addAll(transitions);
        }
        return result;
    }

    public Set<? extends S> getSuccessor(Set<? extends T> transition) {
        HashSet<Object> result = new HashSet<Object>();
        for (T trans : transition) {
            result.add(this.ts.getSuccessor(trans));
        }
        return result;
    }

    @Override
    public Set<? extends S> getSuccessor(Set<? extends S> state, I input) {
        HashSet<Object> result = new HashSet<Object>();
        for (S s : state) {
            Collection transitions = this.ts.getTransitions(s, input);
            for (Object t : transitions) {
                result.add(this.ts.getSuccessor(t));
            }
        }
        return result;
    }

    public Collection<? extends S> getOriginalStates(Set<? extends S> state) {
        return state;
    }

    public Collection<? extends T> getOriginalTransitions(Set<? extends T> transition) {
        return transition;
    }
}

