/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.comp;

import net.automatalib.commons.util.Pair;
import net.automatalib.ts.DeterministicTransitionSystem;
import net.automatalib.ts.abstractimpl.AbstractDTS;

public class DTSComposition<S1, S2, I, T1, T2, TS1 extends DeterministicTransitionSystem<S1, I, T1>, TS2 extends DeterministicTransitionSystem<S2, I, T2>>
extends AbstractDTS<Pair<S1, S2>, I, Pair<T1, T2>> {
    protected final TS1 ts1;
    protected final TS2 ts2;
    protected final boolean allowPartial;

    public DTSComposition(TS1 ts1, TS2 ts2, boolean allowPartial) {
        this.ts1 = ts1;
        this.ts2 = ts2;
        this.allowPartial = allowPartial;
    }

    public DTSComposition(TS1 ts1, TS2 ts2) {
        this(ts1, ts2, false);
    }

    public TS1 getFirstTS() {
        return this.ts1;
    }

    public TS2 getSecondTS() {
        return this.ts2;
    }

    public Pair<S1, S2> getInitialState() {
        return Pair.make((Object)this.ts1.getInitialState(), (Object)this.ts2.getInitialState());
    }

    public Pair<T1, T2> getTransition(Pair<S1, S2> state, I input) {
        Object t2;
        Object t1;
        Object s1 = state.getFirst();
        Object s2 = state.getSecond();
        Object object = t1 = s1 == null ? null : this.ts1.getTransition(s1, input);
        if (t1 == null && !this.allowPartial) {
            return null;
        }
        Object object2 = t2 = s2 == null ? null : this.ts2.getTransition(s2, input);
        if (t2 == null && !this.allowPartial) {
            return null;
        }
        return Pair.make((Object)t1, (Object)t2);
    }

    public Pair<S1, S2> getSuccessor(Pair<T1, T2> transition) {
        Object t1 = transition.getFirst();
        Object t2 = transition.getSecond();
        return Pair.make((Object)(t1 == null ? null : this.ts1.getSuccessor(t1)), t2 == null ? null : this.ts2.getSuccessor(t2));
    }
}

