/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.abstractimpl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import net.automatalib.ts.DeterministicTransitionSystem;
import net.automatalib.ts.abstractimpl.AbstractTS;

public abstract class AbstractDTS<S, I, T>
extends AbstractTS<S, I, T>
implements DeterministicTransitionSystem<S, I, T> {
    public static <S, I, T> Set<S> getInitialStates(DeterministicTransitionSystem<S, I, T> $this) {
        Object init = $this.getInitialState();
        if (init == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(init);
    }

    public static <S, I, T> Set<T> getTransitions(DeterministicTransitionSystem<S, I, T> $this, S state, I input) {
        Object trans = $this.getTransition(state, input);
        if (trans == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(trans);
    }

    public static <S, I, T> S getSuccessor(DeterministicTransitionSystem<S, I, T> $this, S state, I input) {
        Object trans = $this.getTransition(state, input);
        if (trans == null) {
            return null;
        }
        return (S)$this.getSuccessor(trans);
    }

    public static <S, I, T> S getSuccessor(DeterministicTransitionSystem<S, I, T> $this, S state, Iterable<? extends I> input) {
        Object curr = state;
        Iterator<I> it = input.iterator();
        while (curr != null && it.hasNext()) {
            I sym = it.next();
            curr = $this.getSuccessor(curr, sym);
        }
        return curr;
    }

    public static <S, I, T> S getState(DeterministicTransitionSystem<S, I, T> $this, Iterable<? extends I> input) {
        return (S)$this.getSuccessor($this.getInitialState(), input);
    }

    public Set<S> getInitialStates() {
        return AbstractDTS.getInitialStates(this);
    }

    public Collection<? extends T> getTransitions(S state, I input) {
        return AbstractDTS.getTransitions(this, state, input);
    }

    public S getSuccessor(S state, I input) {
        return AbstractDTS.getSuccessor(this, state, input);
    }

    public S getSuccessor(S state, Iterable<? extends I> input) {
        return AbstractDTS.getSuccessor(this, state, input);
    }

    public S getState(Iterable<? extends I> input) {
        return AbstractDTS.getState(this, input);
    }
}

