/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.fsa.impl.compact;

import java.util.BitSet;
import net.automatalib.automata.base.compact.AbstractCompactSimpleDet;
import net.automatalib.automata.dot.DOTHelperFSA;
import net.automatalib.automata.dot.DOTPlottableAutomaton;
import net.automatalib.automata.fsa.MutableDFA;
import net.automatalib.automata.fsa.abstractimpl.AbstractDFA;
import net.automatalib.automata.fsa.abstractimpl.AbstractFSA;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.words.Alphabet;

public class CompactDFA<I>
extends AbstractCompactSimpleDet<I, Boolean>
implements MutableDFA<Integer, I>,
DOTPlottableAutomaton<Integer, I, Integer> {
    public static final float DEFAULT_RESIZE_FACTOR = 1.5f;
    public static final int DEFAULT_INIT_CAPACITY = 11;
    private final BitSet acceptance = new BitSet();

    public CompactDFA(Alphabet<I> alphabet) {
        super(alphabet);
    }

    public CompactDFA(Alphabet<I> alphabet, int stateCapacity) {
        super(alphabet, stateCapacity);
    }

    public CompactDFA(Alphabet<I> alphabet, float resizeFactor) {
        super(alphabet, resizeFactor);
    }

    public CompactDFA(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        super(alphabet, stateCapacity, resizeFactor);
    }

    @Override
    public void ensureCapacity(int oldCap, int newCap) {
        this.acceptance.set(newCap);
    }

    public void flipAcceptance() {
        this.acceptance.flip(0, this.size());
    }

    @Override
    public void clear() {
        this.acceptance.clear();
        super.clear();
    }

    public void setAccepting(int state, boolean accepting) {
        this.acceptance.set(state, accepting);
    }

    public void setAccepting(Integer state, boolean accepting) {
        this.setAccepting((int)state, accepting);
    }

    @Override
    public Integer addState(boolean accepting) {
        return this.addState((Object)accepting);
    }

    public boolean isAccepting(int stateId) {
        return this.acceptance.get(stateId);
    }

    public boolean isAccepting(Integer state) {
        return this.isAccepting((int)state);
    }

    public boolean accepts(Iterable<? extends I> input) {
        return AbstractDFA.accepts(this, input);
    }

    public Boolean computeSuffixOutput(Iterable<? extends I> prefix, Iterable<? extends I> suffix) {
        return AbstractFSA.computeSuffixOutput(this, prefix, suffix);
    }

    public Boolean computeOutput(Iterable<? extends I> input) {
        return AbstractFSA.computeOutput(this, input);
    }

    @Override
    public Boolean getStateProperty(int stateId) {
        return this.isAccepting(stateId);
    }

    @Override
    public void initState(int stateId, Boolean property) {
        boolean bval = property == null ? false : property;
        this.setAccepting(stateId, bval);
    }

    @Override
    public void setStateProperty(int stateId, Boolean property) {
        boolean bval = property == null ? false : property;
        this.setAccepting(stateId, bval);
    }

    @Override
    public Integer addInitialState(boolean accepting) {
        return (Integer)this.addInitialState(Boolean.valueOf(accepting));
    }

    @Override
    public GraphDOTHelper<Integer, TransitionEdge<I, Integer>> getDOTHelper() {
        return new DOTHelperFSA(this);
    }
}

