/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.compact;

import gnu.trove.TCollections;
import gnu.trove.TIntCollection;
import gnu.trove.decorator.TIntSetDecorator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import net.automatalib.automata.FiniteAlphabetAutomaton;
import net.automatalib.automata.abstractimpl.AbstractMutableAutomaton;
import net.automatalib.automata.base.StateIDGrowingMapping;
import net.automatalib.automata.base.StateIDStaticMapping;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.dot.DefaultDOTHelperAutomaton;
import net.automatalib.automata.graphs.AbstractAutomatonGraph;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.UniversalGraph;
import net.automatalib.graphs.concepts.NodeIDs;
import net.automatalib.graphs.dot.DOTPlottableGraph;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.words.Alphabet;

public abstract class AbstractCompactSimpleNondet<I, SP>
extends AbstractMutableAutomaton<Integer, I, Integer, SP, Void>
implements UniversalGraph<Integer, TransitionEdge<I, Integer>, SP, TransitionEdge.Property<I, Void>>,
FiniteAlphabetAutomaton<Integer, I, Integer>,
StateIDs<Integer>,
NodeIDs<Integer>,
DOTPlottableGraph<Integer, TransitionEdge<I, Integer>> {
    public static final TIntSet EMPTY_SET = TCollections.unmodifiableSet((TIntSet)new TIntHashSet());
    public static final float DEFAULT_RESIZE_FACTOR = 1.5f;
    public static final int DEFAULT_INIT_CAPACITY = 11;
    private final Alphabet<I> alphabet;
    private final int alphabetSize;
    private TIntSet[] transitions;
    private int stateCapacity;
    private int numStates;
    private final TIntSet initial = new TIntHashSet();
    private final float resizeFactor;

    public AbstractCompactSimpleNondet(Alphabet<I> alphabet) {
        this(alphabet, 11, 1.5f);
    }

    public AbstractCompactSimpleNondet(Alphabet<I> alphabet, int stateCapacity) {
        this(alphabet, stateCapacity, 1.5f);
    }

    public AbstractCompactSimpleNondet(Alphabet<I> alphabet, float resizeFactor) {
        this(alphabet, 11, resizeFactor);
    }

    public AbstractCompactSimpleNondet(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        this.alphabet = alphabet;
        this.alphabetSize = alphabet.size();
        this.transitions = new TIntSet[stateCapacity * this.alphabetSize];
        this.resizeFactor = resizeFactor;
        this.stateCapacity = stateCapacity;
    }

    public void ensureCapacity(int newCapacity) {
        if (newCapacity <= this.stateCapacity) {
            return;
        }
        int newCap = (int)((float)this.stateCapacity * this.resizeFactor);
        if (newCap < newCapacity) {
            newCap = newCapacity;
        }
        TIntSet[] newTrans = new TIntSet[newCap * this.alphabetSize];
        System.arraycopy(this.transitions, 0, newTrans, 0, this.stateCapacity * this.alphabetSize);
        this.transitions = newTrans;
        this.ensureCapacity(this.stateCapacity, newCap);
        this.stateCapacity = newCap;
    }

    protected void ensureCapacity(int oldCap, int newCap) {
    }

    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    @Override
    public int size() {
        return this.numStates;
    }

    public Collection<Integer> getStates() {
        return CollectionsUtil.intRange((int)0, (int)this.numStates);
    }

    public Integer getState(int id) {
        return id;
    }

    public int getStateId(Integer state) {
        return state;
    }

    public TIntCollection getIntInitialStates() {
        return this.initial;
    }

    public TIntCollection getIntTransitions(int state, I input) {
        int transId = state * this.alphabetSize + this.alphabet.getSymbolIndex(input);
        return this.successors(transId);
    }

    public void removeAllTransitions(int state) {
        int base = state * this.alphabetSize;
        Arrays.fill(this.transitions, base, base + this.alphabetSize, null);
    }

    @Override
    public void removeTransition(Integer state, I input, Integer transition) {
        this.removeTransition((int)state, input, (int)transition);
    }

    @Override
    public void removeTransition(int stateId, I input, int successorId) {
        this.removeTransition(stateId, this.alphabet.getSymbolIndex(input), successorId);
    }

    @Override
    public void removeTransition(int stateId, int inputIdx, int successorId) {
        int transIdx = stateId * this.alphabetSize + inputIdx;
        TIntSet successors = this.transitions[transIdx];
        if (successors != null) {
            successors.remove(successorId);
        }
    }

    @Override
    public void removeAllTransitions(Integer state, I input) {
        this.removeAllTransitions((int)state, input);
    }

    @Override
    public void removeAllTransitions(int stateId, I input) {
        this.removeAllTransitions(stateId, this.alphabet.getSymbolIndex(input));
    }

    @Override
    public void removeAllTransitions(int stateId, int inputIdx) {
        int transIdx = stateId * this.alphabetSize + inputIdx;
        this.transitions[transIdx] = null;
    }

    @Override
    public void addTransition(Integer state, I input, Integer transition) {
        this.addTransition((int)state, input, (int)transition);
    }

    @Override
    public void addTransition(int stateId, I input, int succId) {
        this.addTransition(stateId, this.alphabet.getSymbolIndex(input), succId);
    }

    @Override
    public void addTransition(int stateId, int inputIdx, int succId) {
        int transIdx = stateId * this.alphabetSize + inputIdx;
        TIntSet successors = this.transitions[transIdx];
        if (successors == null) {
            this.transitions[transIdx] = successors = new TIntHashSet();
        }
        successors.add(succId);
    }

    public void removeAllTransitions(Integer state) {
        this.removeAllTransitions((int)state);
    }

    public Integer copyTransition(Integer trans, Integer succ) {
        return succ;
    }

    public Integer getSuccessor(Integer transition) {
        return transition;
    }

    public abstract SP getStateProperty(int var1);

    public SP getStateProperty(Integer state) {
        return this.getStateProperty((int)state);
    }

    public Void getTransitionProperty(Integer transition) {
        return null;
    }

    protected abstract void initState(int var1, SP var2);

    public int addIntState(SP property) {
        int stateId = this.numStates++;
        this.ensureCapacity(this.numStates);
        this.initState(stateId, property);
        return stateId;
    }

    public int addIntState() {
        return this.addIntState(null);
    }

    public int addIntInitialState(SP property) {
        int state = this.addIntState(property);
        this.setInitial(state, true);
        return state;
    }

    public int addIntInitialState() {
        return this.addIntInitialState(null);
    }

    public Integer addState(SP property) {
        return this.addIntState(property);
    }

    public abstract void setStateProperty(int var1, SP var2);

    public void setStateProperty(Integer state, SP property) {
        this.setStateProperty((int)state, property);
    }

    public void setTransitionProperty(Integer transition, Void property) {
    }

    public Integer createTransition(Integer successor, Void properties) {
        return successor;
    }

    @Override
    public StateIDs<Integer> stateIDs() {
        return this;
    }

    public SP getNodeProperty(Integer node) {
        return this.getStateProperty(node);
    }

    public TransitionEdge.Property<I, Void> getEdgeProperty(TransitionEdge<I, Integer> edge) {
        return new TransitionEdge.Property<I, Object>(edge.getInput(), null);
    }

    public Collection<TransitionEdge<I, Integer>> getOutgoingEdges(Integer node) {
        return AbstractAutomatonGraph.getOutgoingEdges(this, node);
    }

    public Integer getTarget(TransitionEdge<I, Integer> edge) {
        return edge.getTransition();
    }

    public <V> MutableMapping<Integer, V> createStaticNodeMapping() {
        return new StateIDStaticMapping(this, this.numStates);
    }

    public <V> MutableMapping<Integer, V> createDynamicNodeMapping() {
        return new StateIDGrowingMapping(this, this);
    }

    public Collection<Integer> getNodes() {
        return this.getStates();
    }

    public NodeIDs<Integer> nodeIDs() {
        return this;
    }

    @Override
    public GraphDOTHelper<Integer, TransitionEdge<I, Integer>> getGraphDOTHelper() {
        return new DefaultDOTHelperAutomaton(this);
    }

    public int getNodeId(Integer node) {
        return node;
    }

    public Integer getNode(int id) {
        return id;
    }

    protected TIntSet successors(int transId) {
        TIntSet successors = this.transitions[transId];
        if (successors == null) {
            return EMPTY_SET;
        }
        return successors;
    }

    protected static Integer wrapState(int id) {
        if (id < 0) {
            return null;
        }
        return id;
    }

    public void clear() {
        Arrays.fill(this.transitions, 0, this.numStates * this.alphabetSize, null);
        this.numStates = 0;
        this.initial.clear();
    }

    public void setInitial(Integer state, boolean initial) {
        this.setInitial((int)state, initial);
    }

    public void setInitial(int state, boolean initial) {
        if (initial) {
            this.initial.add(state);
        } else {
            this.initial.remove(state);
        }
    }

    public void setTransitions(Integer state, I input, Collection<? extends Integer> transitions) {
        TIntArrayList successors = new TIntArrayList(transitions.size());
        for (Integer n : transitions) {
            successors.add(n.intValue());
        }
        this.setTransitions((int)state, input, (TIntCollection)successors);
    }

    public void setTransitions(int state, I input, TIntCollection successors) {
        this.setTransitions(state, this.alphabet.getSymbolIndex(input), successors);
    }

    public void setTransitions(int state, int inputIdx, TIntCollection successors) {
        int transIdx = state * this.alphabetSize + inputIdx;
        TIntSet succs = this.transitions[transIdx];
        if (succs == null) {
            this.transitions[transIdx] = succs = new TIntHashSet(successors);
        } else {
            succs.clear();
            succs.addAll(successors);
        }
    }

    public Collection<? extends Integer> getTransitions(Integer state, I input) {
        return new TIntSetDecorator(this.getTransitions((int)state, input));
    }

    public TIntSet getTransitions(int state, I input) {
        return this.getTransitions(state, this.alphabet.getSymbolIndex(input));
    }

    public TIntSet getTransitions(int state, int inputIdx) {
        return this.successors(state * this.alphabetSize + inputIdx);
    }

    public Set<? extends Integer> getInitialStates() {
        return new TIntSetDecorator(this.initial);
    }
}

