/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.compact;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.FiniteAlphabetAutomaton;
import net.automatalib.automata.abstractimpl.AbstractMutableDeterministic;
import net.automatalib.automata.base.StateIDGrowingMapping;
import net.automatalib.automata.base.StateIDStaticMapping;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.dot.DefaultDOTHelperAutomaton;
import net.automatalib.automata.graphs.AbstractAutomatonGraph;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.UniversalGraph;
import net.automatalib.graphs.concepts.NodeIDs;
import net.automatalib.graphs.dot.DOTPlottableGraph;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.words.Alphabet;

public abstract class AbstractCompactSimpleDet<I, SP>
extends AbstractMutableDeterministic<Integer, I, Integer, SP, Void>
implements UniversalGraph<Integer, TransitionEdge<I, Integer>, SP, TransitionEdge.Property<I, Void>>,
FiniteAlphabetAutomaton<Integer, I, Integer>,
StateIDs<Integer>,
NodeIDs<Integer>,
DOTPlottableGraph<Integer, TransitionEdge<I, Integer>> {
    public static final float DEFAULT_RESIZE_FACTOR = 1.5f;
    public static final int DEFAULT_INIT_CAPACITY = 11;
    private final Alphabet<I> alphabet;
    private final int alphabetSize;
    private int[] transitions;
    private int stateCapacity;
    private int numStates;
    private int initial = -1;
    private final float resizeFactor;

    public AbstractCompactSimpleDet(Alphabet<I> alphabet) {
        this(alphabet, 11, 1.5f);
    }

    public AbstractCompactSimpleDet(Alphabet<I> alphabet, int stateCapacity) {
        this(alphabet, stateCapacity, 1.5f);
    }

    public AbstractCompactSimpleDet(Alphabet<I> alphabet, float resizeFactor) {
        this(alphabet, 11, resizeFactor);
    }

    public AbstractCompactSimpleDet(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        this.alphabet = alphabet;
        this.alphabetSize = alphabet.size();
        this.transitions = new int[stateCapacity * this.alphabetSize];
        Arrays.fill(this.transitions, 0, this.transitions.length, -1);
        this.resizeFactor = resizeFactor;
        this.stateCapacity = stateCapacity;
    }

    public void ensureCapacity(int newCapacity) {
        if (newCapacity <= this.stateCapacity) {
            return;
        }
        int newCap = (int)((float)this.stateCapacity * this.resizeFactor);
        if (newCap < newCapacity) {
            newCap = newCapacity;
        }
        int[] newTrans = new int[newCap * this.alphabetSize];
        System.arraycopy(this.transitions, 0, newTrans, 0, this.stateCapacity * this.alphabetSize);
        Arrays.fill(newTrans, this.transitions.length, newTrans.length, -1);
        this.transitions = newTrans;
        this.ensureCapacity(this.stateCapacity, newCap);
        this.stateCapacity = newCap;
    }

    protected void ensureCapacity(int oldCap, int newCap) {
    }

    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    @Override
    public int size() {
        return this.numStates;
    }

    public Collection<Integer> getStates() {
        return CollectionsUtil.intRange((int)0, (int)this.numStates);
    }

    public Integer getState(int id) {
        return id;
    }

    public int getStateId(Integer state) {
        return state;
    }

    public Integer getInitialState() {
        return AbstractCompactSimpleDet.wrapState(this.initial);
    }

    public int getIntInitialState() {
        return this.initial;
    }

    public Integer getTransition(Integer state, I input) {
        int trans = this.getIntTransition(state, input);
        return AbstractCompactSimpleDet.wrapState(trans);
    }

    public int getIntTransition(int state, I input) {
        int transId = state * this.alphabetSize + this.alphabet.getSymbolIndex(input);
        return this.transitions[transId];
    }

    public void setInitialState(int state) {
        this.initial = state;
    }

    public void setInitialState(Integer state) {
        this.setInitialState(state != null ? state : -1);
    }

    public void setTransition(int state, int inputIdx, int succ) {
        this.transitions[state * this.alphabetSize + inputIdx] = succ;
    }

    public void setTransition(int state, I input, int succ) {
        this.setTransition(state, this.alphabet.getSymbolIndex(input), succ);
    }

    public void setTransition(Integer state, I input, Integer transition) {
        int succId = transition != null ? transition : -1;
        this.setTransition((int)state, input, succId);
    }

    public void clear() {
        int endIdx = this.numStates * this.alphabetSize;
        this.numStates = 0;
        Arrays.fill(this.transitions, 0, endIdx, -1);
        this.initial = -1;
    }

    public void removeAllTransitions(int state) {
        int base = state * this.alphabetSize;
        Arrays.fill(this.transitions, base, base + this.alphabetSize, -1);
    }

    public void removeAllTransitions(Integer state) {
        this.removeAllTransitions((int)state);
    }

    public Integer copyTransition(Integer trans, Integer succ) {
        return succ;
    }

    public Integer getSuccessor(Integer transition) {
        return transition;
    }

    public int getIntSuccessor(int state, I input) {
        return this.getIntTransition(state, input);
    }

    public abstract SP getStateProperty(int var1);

    public SP getStateProperty(Integer state) {
        return this.getStateProperty((int)state);
    }

    public Void getTransitionProperty(Integer transition) {
        return null;
    }

    protected abstract void initState(int var1, SP var2);

    public int addIntState(SP property) {
        int stateId = this.numStates++;
        this.ensureCapacity(this.numStates);
        this.initState(stateId, property);
        return stateId;
    }

    public int addIntState() {
        return this.addIntState(null);
    }

    public int addIntInitialState(SP property) {
        int state = this.addIntState(property);
        this.setInitialState(state);
        return state;
    }

    public int addIntInitialState() {
        return this.addIntInitialState(null);
    }

    public Integer addState(SP property) {
        return this.addIntState(property);
    }

    public abstract void setStateProperty(int var1, SP var2);

    public void setStateProperty(Integer state, SP property) {
        this.setStateProperty((int)state, property);
    }

    public void setTransitionProperty(Integer transition, Void property) {
    }

    public Integer createTransition(Integer successor, Void properties) {
        return successor;
    }

    @Override
    public StateIDs<Integer> stateIDs() {
        return this;
    }

    public SP getNodeProperty(Integer node) {
        return this.getStateProperty(node);
    }

    public TransitionEdge.Property<I, Void> getEdgeProperty(TransitionEdge<I, Integer> edge) {
        return new TransitionEdge.Property<I, Object>(edge.getInput(), null);
    }

    public Collection<TransitionEdge<I, Integer>> getOutgoingEdges(Integer node) {
        return AbstractAutomatonGraph.getOutgoingEdges(this, node);
    }

    public Integer getTarget(TransitionEdge<I, Integer> edge) {
        return edge.getTransition();
    }

    public <V> MutableMapping<Integer, V> createStaticNodeMapping() {
        return new StateIDStaticMapping(this, this.numStates);
    }

    public <V> MutableMapping<Integer, V> createDynamicNodeMapping() {
        return new StateIDGrowingMapping((Automaton<Integer, ?, ?>)this, this);
    }

    public Collection<Integer> getNodes() {
        return this.getStates();
    }

    public NodeIDs<Integer> nodeIDs() {
        return this;
    }

    @Override
    public GraphDOTHelper<Integer, TransitionEdge<I, Integer>> getGraphDOTHelper() {
        return new DefaultDOTHelperAutomaton(this);
    }

    public int getNodeId(Integer node) {
        return node;
    }

    public Integer getNode(int id) {
        return id;
    }

    public int getIntSuccessor(int state, Iterable<? extends I> input) {
        int current = state;
        Iterator<I> inputIt = input.iterator();
        while (current >= 0 && inputIt.hasNext()) {
            current = this.getIntSuccessor(current, inputIt.next());
        }
        return current;
    }

    @Override
    public Integer getSuccessor(Integer state, Iterable<? extends I> input) {
        return AbstractCompactSimpleDet.wrapState(this.getIntSuccessor((int)state, input));
    }

    public int getIntState(Iterable<? extends I> input) {
        return this.getIntSuccessor(this.initial, input);
    }

    @Override
    public Integer getState(Iterable<? extends I> input) {
        return AbstractCompactSimpleDet.wrapState(this.getIntState(input));
    }

    protected static Integer wrapState(int id) {
        if (id < 0) {
            return null;
        }
        return id;
    }
}

