/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.compact;

import java.util.Collection;
import net.automatalib.automata.FiniteAlphabetAutomaton;
import net.automatalib.automata.abstractimpl.AbstractMutableDeterministic;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.graphs.AbstractAutomatonGraph;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.concepts.NodeIDs;
import net.automatalib.words.Alphabet;

public abstract class AbstractCompactDeterministic<I, T, SP, TP>
extends AbstractMutableDeterministic<Integer, I, T, SP, TP>
implements StateIDs<Integer>,
FiniteAlphabetAutomaton<Integer, I, T>,
Graph<Integer, TransitionEdge<I, T>> {
    public static final float DEFAULT_RESIZE_FACTOR = 1.5f;
    public static final int DEFAULT_INIT_CAPACITY = 11;
    protected final Alphabet<I> alphabet;
    protected final int alphabetSize;
    protected Object[] transitions;
    protected int stateCapacity;
    protected int numStates;
    protected int initial = -1;
    protected final float resizeFactor;

    protected static final int getId(Integer id) {
        return id != null ? id : -1;
    }

    protected static final Integer makeId(int id) {
        return id != -1 ? Integer.valueOf(id) : null;
    }

    public AbstractCompactDeterministic(Alphabet<I> alphabet) {
        this(alphabet, 11, 1.5f);
    }

    public AbstractCompactDeterministic(Alphabet<I> alphabet, int stateCapacity) {
        this(alphabet, stateCapacity, 1.5f);
    }

    public AbstractCompactDeterministic(Alphabet<I> alphabet, float resizeFactor) {
        this(alphabet, 11, resizeFactor);
    }

    public AbstractCompactDeterministic(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        this.alphabet = alphabet;
        this.alphabetSize = alphabet.size();
        this.transitions = new Object[stateCapacity * this.alphabetSize];
        this.resizeFactor = resizeFactor;
        this.stateCapacity = stateCapacity;
    }

    protected void ensureCapacity() {
    }

    public final void ensureCapacity(int newCapacity) {
        if (newCapacity <= this.stateCapacity) {
            return;
        }
        int newCap = (int)((float)this.stateCapacity * this.resizeFactor);
        if (newCap < newCapacity) {
            newCap = newCapacity;
        }
        Object[] newTrans = new Object[newCap * this.alphabetSize];
        System.arraycopy(this.transitions, 0, newTrans, 0, this.stateCapacity * this.alphabetSize);
        this.transitions = newTrans;
        this.stateCapacity = newCap;
        this.ensureCapacity();
    }

    public void setInitialState(int stateId) {
        this.initial = stateId;
    }

    public void setInitialState(Integer state) {
        this.setInitialState(AbstractCompactDeterministic.getId(state));
    }

    public void setTransition(int state, int inputIdx, T trans) {
        this.transitions[state * this.alphabetSize + inputIdx] = trans;
    }

    public void setTransition(int stateId, int inputIdx, int succId) {
        this.setTransition(stateId, inputIdx, succId, (TP)null);
    }

    @Override
    public void setTransition(int stateId, int inputIdx, int succId, TP property) {
        this.setTransition(stateId, inputIdx, this.createTransition(succId, property));
    }

    public void setTransition(Integer state, I input, T transition) {
        this.setTransition(AbstractCompactDeterministic.getId(state), this.alphabet.getSymbolIndex(input), transition);
    }

    public abstract T createTransition(int var1, TP var2);

    public T createTransition(Integer succ, TP property) {
        return this.createTransition(AbstractCompactDeterministic.getId(succ), property);
    }

    public T copyTransition(T trans, Integer succ) {
        return this.copyTransition(trans, AbstractCompactDeterministic.getId(succ));
    }

    public abstract T copyTransition(T var1, int var2);

    public abstract int getIntSuccessor(T var1);

    public final Integer getSuccessor(T transition) {
        return AbstractCompactDeterministic.makeId(this.getIntSuccessor(transition));
    }

    public Collection<Integer> getStates() {
        return CollectionsUtil.intRange((int)0, (int)this.numStates);
    }

    public Integer getState(int id) {
        return id;
    }

    public int getStateId(Integer state) {
        return state;
    }

    public int getIntInitialState() {
        return this.initial;
    }

    public Integer getInitialState() {
        return AbstractCompactDeterministic.makeId(this.initial);
    }

    public T getTransition(int stateId, int inputIdx) {
        return (T)this.transitions[stateId * this.alphabetSize + inputIdx];
    }

    public T getTransition(int stateId, I input) {
        return this.getTransition(stateId, (I)this.alphabet.getSymbolIndex(input));
    }

    public T getTransition(Integer state, I input) {
        return this.getTransition(AbstractCompactDeterministic.getId(state), (I)this.alphabet.getSymbolIndex(input));
    }

    public abstract SP getStateProperty(int var1);

    public SP getStateProperty(Integer state) {
        return this.getStateProperty(AbstractCompactDeterministic.getId(state));
    }

    public void clear() {
        int endIdx = this.numStates * this.alphabetSize;
        this.numStates = 0;
        for (int i = 0; i < endIdx; ++i) {
            this.transitions[i] = null;
        }
        this.initial = -1;
    }

    protected final int createState() {
        int newState = this.numStates++;
        this.ensureCapacity(this.numStates);
        return newState;
    }

    public int addIntInitialState(SP property) {
        int newState = this.addIntState(property);
        this.setInitialState(newState);
        return newState;
    }

    public int addIntInitialState() {
        return this.addIntInitialState(null);
    }

    public int addIntState() {
        return this.addIntState(null);
    }

    public int addIntState(SP property) {
        int newState = this.createState();
        this.setStateProperty(newState, property);
        return newState;
    }

    public Integer addState(SP property) {
        return this.addIntState(property);
    }

    public abstract void setStateProperty(int var1, SP var2);

    public void setStateProperty(Integer state, SP property) {
        this.setStateProperty((int)state, property);
    }

    public void removeAllTransitions(Integer state) {
        int base = state * this.alphabetSize;
        for (int i = 0; i < this.alphabetSize; ++i) {
            this.transitions[base++] = null;
        }
    }

    @Override
    public StateIDs<Integer> stateIDs() {
        return this;
    }

    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    public Collection<TransitionEdge<I, T>> getOutgoingEdges(Integer node) {
        return AbstractAutomatonGraph.getOutgoingEdges(this, node);
    }

    public Integer getTarget(TransitionEdge<I, T> edge) {
        return (Integer)AbstractAutomatonGraph.getTarget(this, edge);
    }

    public <V> MutableMapping<Integer, V> createStaticNodeMapping() {
        return AbstractAutomatonGraph.createStaticNodeMapping(this);
    }

    public <V> MutableMapping<Integer, V> createDynamicNodeMapping() {
        return AbstractAutomatonGraph.createDynamicNodeMapping(this);
    }

    public Collection<Integer> getNodes() {
        return AbstractAutomatonGraph.getNodes(this);
    }

    public NodeIDs<Integer> nodeIDs() {
        return AbstractAutomatonGraph.nodeIDs(this);
    }
}

