/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.abstractimpl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.automata.ShrinkableAutomaton;
import net.automatalib.automata.abstractimpl.AbstractMutableAutomaton;

public abstract class AbstractShrinkableAutomaton<S, I, T, SP, TP>
extends AbstractMutableAutomaton<S, I, T, SP, TP>
implements ShrinkableAutomaton<S, I, T, SP, TP> {
    public static <S, I, T, SP, TP> void removeState(ShrinkableAutomaton<S, I, T, SP, TP> $this, S state) {
        $this.removeState(state, null);
    }

    public static <S, I, T, SP, TP> void unlinkState(MutableAutomaton<S, I, T, SP, TP> automaton, S state, S replacement, Collection<I> inputs) {
        for (Object curr : automaton) {
            if (state.equals(curr)) continue;
            for (I input : inputs) {
                Collection transitions = automaton.getTransitions(curr, input);
                if (transitions.isEmpty()) continue;
                boolean modified = false;
                LinkedList modTransitions = new LinkedList(transitions);
                ListIterator<Object> it = modTransitions.listIterator();
                while (it.hasNext()) {
                    Object trans = it.next();
                    if (automaton.getSuccessor(trans) != state) continue;
                    if (replacement == null) {
                        it.remove();
                    } else {
                        Object transRep = automaton.copyTransition(trans, replacement);
                        it.set(transRep);
                    }
                    modified = true;
                }
                if (!modified) continue;
                automaton.setTransitions(curr, input, modTransitions);
            }
        }
        if (automaton.getInitialStates().contains(state)) {
            automaton.setInitial(state, false);
            if (replacement != null) {
                automaton.setInitial(replacement, true);
            }
        }
    }

    public void removeState(S state) {
        AbstractShrinkableAutomaton.removeState(this, state);
    }
}

