/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.powerset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.ts.abstractimpl.AbstractDTS;

public class PowersetDTS<S, I, T>
extends AbstractDTS<Set<S>, I, Collection<T>> {
    private final TransitionSystem<S, I, T> ts;

    public PowersetDTS(TransitionSystem<S, I, T> ts) {
        this.ts = ts;
    }

    public Set<S> getInitialState() {
        return this.ts.getInitialStates();
    }

    public Collection<T> getTransition(Set<S> state, I input) {
        ArrayList result = new ArrayList();
        for (S s : state) {
            Collection transitions = this.ts.getTransitions(s, input);
            if (transitions == null) continue;
            result.addAll(transitions);
        }
        return result;
    }

    public Set<S> getSuccessor(Collection<T> transition) {
        HashSet<Object> result = new HashSet<Object>();
        for (T trans : transition) {
            result.add(this.ts.getSuccessor(trans));
        }
        return result;
    }

    @Override
    public Set<S> getSuccessor(Set<S> state, I input) {
        HashSet<Object> result = new HashSet<Object>();
        for (S s : state) {
            Collection transitions = this.ts.getTransitions(s, input);
            if (transitions == null) continue;
            for (Object t : transitions) {
                result.add(this.ts.getSuccessor(t));
            }
        }
        return result;
    }
}

