/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graphs.dot;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.graphs.dot.GraphDOTHelper;

public class DefaultDOTHelper<N, E>
implements GraphDOTHelper<N, E> {
    protected static final String START_PREFIX = "__start";
    private static final DefaultDOTHelper<Object, Object> DEFAULT_INSTANCE = new DefaultDOTHelper();

    public static DefaultDOTHelper<Object, Object> getInstance() {
        return DEFAULT_INSTANCE;
    }

    protected Collection<? extends N> initialNodes() {
        return Collections.emptySet();
    }

    @Override
    public void writePreamble(Appendable a) throws IOException {
        int size = this.initialNodes().size();
        for (int i = 0; i < size; ++i) {
            a.append(START_PREFIX).append(Integer.toString(i));
            a.append(" [label=\"\" shape=\"none\"];\n");
        }
    }

    @Override
    public void writePostamble(Mapping<N, String> identifiers, Appendable a) throws IOException {
        Collection<N> initials = this.initialNodes();
        int i = 0;
        for (N init : initials) {
            a.append(START_PREFIX).append(Integer.toString(i++));
            a.append(" -> ").append((CharSequence)identifiers.get(init)).append(";\n");
        }
    }

    @Override
    public boolean getNodeProperties(N node, Map<String, String> properties) {
        String label = String.valueOf(node);
        properties.put("label", label);
        properties.put("shape", "circle");
        return true;
    }

    @Override
    public boolean getEdgeProperties(N src, E edge, N tgt, Map<String, String> properties) {
        return true;
    }
}

