/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.fast;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.automata.FiniteAlphabetAutomaton;
import net.automatalib.automata.abstractimpl.AbstractShrinkableAutomaton;
import net.automatalib.automata.base.StateIDDynamicMapping;
import net.automatalib.automata.base.StateIDStaticMapping;
import net.automatalib.automata.base.fast.FastNondetState;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.graphs.AbstractAutomatonGraph;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.commons.util.nid.DynamicList;
import net.automatalib.commons.util.nid.IDChangeNotifier;
import net.automatalib.graphs.UniversalGraph;
import net.automatalib.graphs.concepts.NodeIDs;
import net.automatalib.words.Alphabet;

public abstract class FastMutableNondet<S extends FastNondetState<S, T>, I, T, SP, TP>
extends AbstractShrinkableAutomaton<S, I, T, SP, TP>
implements FiniteAlphabetAutomaton<S, I, T>,
UniversalGraph<S, TransitionEdge<I, T>, SP, TransitionEdge.Property<I, TP>>,
StateIDs<S>,
NodeIDs<S> {
    private final DynamicList<S> states = new DynamicList();
    private final IDChangeNotifier<S> tracker = new IDChangeNotifier();
    private final Set<S> initialStates = new HashSet<S>();
    protected Alphabet<I> inputAlphabet;

    public FastMutableNondet(Alphabet<I> inputAlphabet) {
        this.inputAlphabet = inputAlphabet;
    }

    public Collection<S> getStates() {
        return this.states;
    }

    public S getState(int id) {
        return (S)((Object)((FastNondetState)this.states.get(id)));
    }

    public int getStateId(S state) {
        return state.getId();
    }

    public Set<S> getInitialStates() {
        return this.initialStates;
    }

    public Collection<T> getTransitions(S state, I input) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        return ((FastNondetState)((Object)state)).getTransitions(inputIdx);
    }

    public void clear() {
        this.states.clear();
        this.initialStates.clear();
    }

    public S addState(SP property) {
        S newState = this.createState(property);
        this.states.add(newState);
        return newState;
    }

    public void setInitial(S state, boolean initial) {
        if (initial) {
            this.initialStates.add(state);
        } else {
            this.initialStates.remove(state);
        }
    }

    public void removeState(S state, S replacement) {
        AbstractShrinkableAutomaton.unlinkState(this, state, replacement, this.inputAlphabet);
        this.states.remove(state);
        if (this.initialStates.remove(state)) {
            this.initialStates.add(state);
        }
    }

    public void removeAllTransitions(S state) {
        ((FastNondetState)((Object)state)).clearTransitions();
    }

    public void setTransitions(S state, I input, Collection<? extends T> transitions) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        ((FastNondetState)((Object)state)).setTransitions(inputIdx, transitions);
    }

    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    @Override
    public StateIDs<S> stateIDs() {
        return this;
    }

    @Override
    public <V> MutableMapping<S, V> createStaticStateMapping() {
        return new StateIDStaticMapping(this, this.size());
    }

    @Override
    public <V> MutableMapping<S, V> createDynamicStateMapping() {
        StateIDDynamicMapping mapping = new StateIDDynamicMapping(this);
        this.tracker.addListener(mapping, true);
        return mapping;
    }

    public <V> MutableMapping<S, V> createStaticNodeMapping() {
        return AbstractAutomatonGraph.createStaticNodeMapping(this);
    }

    public <V> MutableMapping<S, V> createDynamicNodeMapping() {
        return AbstractAutomatonGraph.createDynamicNodeMapping(this);
    }

    public int getNodeId(S node) {
        return node.getId();
    }

    public S getNode(int id) {
        return (S)((Object)((FastNondetState)this.states.get(id)));
    }

    public Collection<S> getNodes() {
        return AbstractAutomatonGraph.getNodes(this);
    }

    public Collection<TransitionEdge<I, T>> getOutgoingEdges(S node) {
        return AbstractAutomatonGraph.getOutgoingEdges(this, node);
    }

    public S getTarget(TransitionEdge<I, T> edge) {
        return (S)((Object)((FastNondetState)((Object)AbstractAutomatonGraph.getTarget(this, edge))));
    }

    public NodeIDs<S> nodeIDs() {
        return this;
    }

    public SP getNodeProperty(S node) {
        return AbstractAutomatonGraph.getNodeProperties(this, node);
    }

    public TransitionEdge.Property<I, TP> getEdgeProperty(TransitionEdge<I, T> edge) {
        return AbstractAutomatonGraph.getEdgeProperties(this, edge);
    }

    protected abstract S createState(SP var1);
}

