/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.transout.abstractimpl;

import java.util.Collection;
import java.util.List;
import net.automatalib.automata.transout.TransitionOutputAutomaton;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public abstract class AbstractTransOutAutomaton {
    public static <S, I, T, O> Word<O> computeOutput(TransitionOutputAutomaton<S, I, T, O> $this, Iterable<I> input) {
        WordBuilder result = input instanceof Collection ? new WordBuilder(((Collection)input).size()) : new WordBuilder();
        $this.trace(input, (List)result);
        return result.toWord();
    }

    public static <S, I, T, O> Word<O> computeSuffixOutput(TransitionOutputAutomaton<S, I, T, O> $this, Iterable<I> prefix, Iterable<I> suffix) {
        WordBuilder result = suffix instanceof Collection ? new WordBuilder(((Collection)suffix).size()) : new WordBuilder();
        Object state = $this.getState(prefix);
        $this.trace(state, suffix, (List)result);
        return result.toWord();
    }

    public static <S, I, T, O> void trace(TransitionOutputAutomaton<S, I, T, O> $this, Iterable<I> input, List<O> output) {
        $this.trace($this.getInitialState(), input, output);
    }

    public static <S, I, T, O> void trace(TransitionOutputAutomaton<S, I, T, O> $this, S state, Iterable<I> input, List<O> output) {
        for (I sym : input) {
            Object trans = $this.getTransition(state, sym);
            Object out = $this.getTransitionOutput(trans);
            output.add(out);
            state = $this.getSuccessor(trans);
        }
    }

    public static <S, I, T, O> O getOutput(TransitionOutputAutomaton<S, I, T, O> $this, S state, I input) {
        Object trans = $this.getTransition(state, input);
        if (trans == null) {
            return null;
        }
        return (O)$this.getTransitionOutput(trans);
    }
}

