/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.modal;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.base.AbstractCompact;
import net.automatalib.common.util.collection.PositiveIntSet;
import net.automatalib.ts.modal.MutableModalTransitionSystem;
import net.automatalib.ts.modal.transition.ModalEdgeProperty;
import net.automatalib.ts.modal.transition.MutableModalEdgeProperty;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractCompactMTS<I, T, TP extends MutableModalEdgeProperty>
extends AbstractCompact<I, T, Void, TP>
implements MutableModalTransitionSystem<Integer, I, T, TP> {
    private final BitSet initialStates = new BitSet();
    private @Nullable Set<T>[] transitions;

    public AbstractCompactMTS(Alphabet<I> alphabet) {
        this(alphabet, 11, 1.5f);
    }

    public AbstractCompactMTS(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        super(alphabet, stateCapacity, resizeFactor);
        this.transitions = new Set[stateCapacity * this.numInputs()];
    }

    public void setInitial(Integer state, boolean initial) {
        if (initial) {
            this.initialStates.set(state);
        } else {
            this.initialStates.clear(state);
        }
    }

    public void setStateProperty(Integer state, Void property) {
    }

    @Override
    public void setStateProperty(int state, Void property) {
    }

    public void setTransitions(Integer state, I input, Collection<? extends T> transitions) {
        this.transitions[this.toMemoryIndex((int)state.intValue(), (int)this.getSymbolIndex(input))] = new HashSet<T>(transitions);
    }

    public void removeAllTransitions(Integer state, I input) {
        this.transitions[this.toMemoryIndex((int)state.intValue(), (int)this.getSymbolIndex(input))] = null;
    }

    public void removeAllTransitions(Integer state) {
        for (Object i : this.getInputAlphabet()) {
            this.removeAllTransitions(state, i);
        }
    }

    public T addModalTransition(Integer src, I input, Integer tgt, ModalEdgeProperty.ModalType modalType) {
        return (T)this.addTransition(src, input, tgt, this.buildModalProperty(modalType));
    }

    public Void getStateProperty(Integer state) {
        return null;
    }

    public Collection<T> getTransitions(Integer state, I input) {
        Set<T> trans = this.transitions[this.toMemoryIndex(state, this.getSymbolIndex(input))];
        return trans == null ? Collections.emptySet() : Collections.unmodifiableCollection(trans);
    }

    public Set<Integer> getInitialStates() {
        return new PositiveIntSet(this.initialStates);
    }

    @Override
    public void clear() {
        Arrays.fill(this.transitions, 0, this.size() * this.numInputs(), null);
        this.initialStates.clear();
        super.clear();
    }

    @Override
    protected void updateTransitionStorage(AbstractCompact.Payload payload) {
        this.transitions = this.updateTransitionStorage(this.transitions, Set[]::new, null, payload);
        super.updateTransitionStorage(payload);
    }

    protected abstract TP getDefaultTransitionProperty();

    protected abstract TP buildModalProperty(ModalEdgeProperty.ModalType var1);
}

