/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecking;

import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.automaton.concept.DetOutputAutomaton;
import net.automatalib.common.util.collection.CollectionsUtil;
import net.automatalib.modelchecking.Lasso;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractLasso<I, D>
implements Lasso<I, D> {
    public static final String NO_LASSO = "Automaton is not lasso shaped";
    private final Word<I> word;
    private final Word<I> loop;
    private final Word<I> prefix;
    private final D output;
    private final Alphabet<I> inputAlphabet;
    private final int unfolds;
    private final SortedSet<Integer> loopBeginIndices = new TreeSet<Integer>();
    private final DetOutputAutomaton<?, I, ?, D> automaton;

    public <S> AbstractLasso(DetOutputAutomaton<S, I, ?, D> automaton, Collection<? extends I> inputs, int unfoldTimes) {
        assert (unfoldTimes > 0);
        this.automaton = automaton;
        this.unfolds = unfoldTimes;
        this.inputAlphabet = Alphabets.fromCollection(inputs);
        HashMap<Object, Integer> states = new HashMap<Object, Integer>();
        WordBuilder wb = new WordBuilder();
        Object current = automaton.getInitialState();
        assert (current != null) : "Automaton is not lasso shaped";
        int i = 0;
        do {
            states.put(current, i++);
            Object c = current;
            Object input = this.inputAlphabet.stream().filter(in -> automaton.getSuccessor(c, in) != null).findAny().orElseThrow(() -> new IllegalArgumentException(NO_LASSO));
            wb.append(input);
            current = automaton.getSuccessor(current, input);
            assert (current != null);
        } while (!states.containsKey(current));
        int loopBegin = (Integer)states.get(current);
        this.loop = wb.toWord(loopBegin, wb.size());
        this.prefix = wb.toWord(0, loopBegin);
        for (int u = 1; u < unfoldTimes; ++u) {
            wb.append(this.loop);
        }
        this.word = wb.toWord();
        this.output = automaton.computeOutput(this.word);
        for (int l = this.prefix.length(); l <= this.word.length(); l += this.loop.length()) {
            this.loopBeginIndices.add(l);
        }
    }

    public DetOutputAutomaton<?, I, ?, D> getAutomaton() {
        return this.automaton;
    }

    public int getUnfolds() {
        return this.unfolds;
    }

    public Word<I> getWord() {
        return this.word;
    }

    public Word<I> getLoop() {
        return this.loop;
    }

    public Word<I> getPrefix() {
        return this.prefix;
    }

    public D getOutput() {
        return this.output;
    }

    public SortedSet<Integer> getLoopBeginIndices() {
        return this.loopBeginIndices;
    }

    public Integer getInitialState() {
        return 0;
    }

    public @Nullable Integer getSuccessor(Integer state, I input) {
        Integer result = state < this.word.length() && Objects.equals(input, this.word.getSymbol(state.intValue())) ? Integer.valueOf(state + 1) : null;
        return result;
    }

    public Collection<Integer> getStates() {
        return CollectionsUtil.intRange((int)0, (int)this.word.length());
    }

    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    public @Nullable Integer getTransition(Integer state, I input) {
        return this.getSuccessor(state, input);
    }
}

