/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graph.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.automatalib.common.smartcollection.ResizingArrayStorage;
import net.automatalib.common.util.collection.CollectionsUtil;
import net.automatalib.graph.MutableGraph;
import net.automatalib.graph.base.CompactEdge;
import net.automatalib.graph.concept.NodeIDs;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractCompactGraph<E extends CompactEdge<EP>, NP, EP>
implements MutableGraph<Integer, E, NP, EP>,
MutableGraph.IntAbstraction<E, NP, EP>,
NodeIDs<Integer> {
    private final ResizingArrayStorage<List<E>> edges;
    private int size;

    public AbstractCompactGraph() {
        this.edges = new ResizingArrayStorage(List.class);
    }

    public AbstractCompactGraph(int initialCapacity) {
        this.edges = new ResizingArrayStorage(List.class, initialCapacity);
    }

    public int size() {
        return this.size;
    }

    public Collection<Integer> getNodes() {
        return CollectionsUtil.intRange((int)0, (int)this.size);
    }

    public NodeIDs<Integer> nodeIDs() {
        return this;
    }

    public Collection<E> getOutgoingEdges(Integer node) {
        return this.getOutgoingEdges((int)node);
    }

    public Collection<E> getOutgoingEdges(int node) {
        return Collections.unmodifiableCollection(((List[])this.edges.array)[node]);
    }

    public Integer getTarget(E edge) {
        return this.getIntTarget(edge);
    }

    public int getIntTarget(E edge) {
        return ((CompactEdge)edge).getTarget();
    }

    public Integer addNode(@Nullable NP property) {
        return this.addIntNode(property);
    }

    public int addIntNode(@Nullable NP property) {
        int n = this.size++;
        this.edges.ensureCapacity(n + 1);
        ((List[])this.edges.array)[n] = new ArrayList();
        this.setNodeProperty(n, property);
        return n;
    }

    public void setNodeProperty(Integer node, @Nullable NP property) {
        this.setNodeProperty(node, property);
    }

    public E connect(Integer source, Integer target, @Nullable EP property) {
        return (E)this.connect((int)source, (int)target, (Object)property);
    }

    public E connect(int source, int target, @Nullable EP property) {
        E edge = this.createEdge(source, target, property);
        List edges = ((List[])this.edges.array)[source];
        edges.add(edge);
        return edge;
    }

    protected abstract E createEdge(int var1, int var2, @Nullable EP var3);

    public void setEdgeProperty(E edge, EP property) {
        ((CompactEdge)edge).setProperty(property);
    }

    public int getNodeId(Integer node) {
        return node;
    }

    public Integer getNode(int id) {
        if (id < 0 || id >= this.size) {
            throw new IllegalArgumentException();
        }
        return id;
    }

    public NP getNodeProperty(Integer node) {
        return (NP)this.getNodeProperty(node);
    }

    public EP getEdgeProperty(E edge) {
        return ((CompactEdge)edge).getProperty();
    }
}

