/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graph.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.automatalib.common.smartcollection.ResizingArrayStorage;
import net.automatalib.graph.BidirectionalGraph;
import net.automatalib.graph.MutableUniversalBidirectionalGraph;
import net.automatalib.graph.base.AbstractCompactGraph;
import net.automatalib.graph.base.CompactBidiEdge;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractCompactBidiGraph<@Nullable NP, @Nullable EP>
extends AbstractCompactGraph<CompactBidiEdge<EP>, NP, EP>
implements MutableUniversalBidirectionalGraph<Integer, CompactBidiEdge<EP>, NP, EP>,
BidirectionalGraph.IntAbstraction<CompactBidiEdge<EP>> {
    private final ResizingArrayStorage<List<CompactBidiEdge<EP>>> inEdges;

    public AbstractCompactBidiGraph() {
        this.inEdges = new ResizingArrayStorage(List.class);
    }

    public AbstractCompactBidiGraph(int initialCapacity) {
        super(initialCapacity);
        this.inEdges = new ResizingArrayStorage(List.class, initialCapacity);
    }

    public Collection<CompactBidiEdge<EP>> getIncomingEdges(Integer node) {
        return this.getIncomingEdges((int)node);
    }

    public Collection<CompactBidiEdge<EP>> getIncomingEdges(int node) {
        return Collections.unmodifiableCollection(((List[])this.inEdges.array)[node]);
    }

    @Override
    public int addIntNode(@Nullable NP property) {
        int node = super.addIntNode(property);
        this.inEdges.ensureCapacity(node + 1);
        ((List[])this.inEdges.array)[node] = new ArrayList();
        return node;
    }

    public Integer getSource(CompactBidiEdge<EP> edge) {
        return this.getIntSource(edge);
    }

    public int getIntSource(CompactBidiEdge<EP> edge) {
        return edge.getSource();
    }

    @Override
    public CompactBidiEdge<EP> connect(int source, int target, @Nullable EP property) {
        CompactBidiEdge edge = (CompactBidiEdge)super.connect(source, target, (Object)property);
        List inEdges = ((List[])this.inEdges.array)[target];
        inEdges.add(edge);
        return edge;
    }

    @Override
    protected CompactBidiEdge<EP> createEdge(int source, int target, @Nullable EP property) {
        return new CompactBidiEdge<EP>(source, target, property);
    }
}

