/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.vpa;

import java.util.Objects;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.automaton.vpa.AbstractDefaultSEVPA;
import net.automatalib.automaton.vpa.Location;
import net.automatalib.common.smartcollection.ResizingArrayStorage;

public class DefaultNSEVPA<I>
extends AbstractDefaultSEVPA<I> {
    private final Location[] moduleEntries;
    private final ResizingArrayStorage<I> moduleMapping;

    public DefaultNSEVPA(VPAlphabet<I> alphabet) {
        this(alphabet, 10);
    }

    public DefaultNSEVPA(VPAlphabet<I> alphabet, int capacityHint) {
        super(alphabet, capacityHint);
        this.moduleEntries = new Location[alphabet.getNumCalls()];
        this.moduleMapping = new ResizingArrayStorage(Object.class);
    }

    @Override
    public Location addLocation(boolean accepting) {
        Location loc = super.addLocation(accepting);
        this.moduleMapping.ensureCapacity(loc.getIndex() + 1);
        return loc;
    }

    public Location addLocation(I module, boolean accepting) {
        Location result = this.addLocation(accepting);
        this.moduleMapping.array[result.getIndex()] = module;
        return result;
    }

    public Location addModuleEntryLocation(I callSym, boolean accepting) {
        Location loc;
        this.moduleEntries[this.alphabet.getCallSymbolIndex(callSym)] = loc = this.addLocation(callSym, accepting);
        return loc;
    }

    @Override
    public void setInternalSuccessor(Location loc, I intSym, Location succ) {
        Object tgtModule;
        Object srcModule = this.moduleMapping.array[loc.getIndex()];
        if (!Objects.equals(srcModule, tgtModule = this.moduleMapping.array[succ.getIndex()])) {
            throw new IllegalArgumentException("Cannot set internal success across different modules");
        }
        super.setInternalSuccessor(loc, intSym, succ);
    }

    @Override
    public void setReturnSuccessor(Location loc, I retSym, int stackSym, Location succ) {
        Object tgtModule;
        Location callLoc = (Location)super.getStackLoc(stackSym);
        Object srcModule = this.moduleMapping.array[callLoc.getIndex()];
        if (!Objects.equals(srcModule, tgtModule = this.moduleMapping.array[succ.getIndex()])) {
            throw new IllegalArgumentException("Must return to the module that was called");
        }
        super.setReturnSuccessor(loc, retSym, stackSym, succ);
    }

    public Location getModuleEntry(I callSym) {
        return this.moduleEntries[this.alphabet.getCallSymbolIndex(callSym)];
    }
}

